% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_helpers.R
\name{prAddCells}
\alias{prAddCells}
\title{Add a cell}
\usage{
prAddCells(
  rowcells,
  cellcode,
  align,
  style,
  cgroup_spacer_cells,
  has_rn_col,
  col.columns,
  offset = 1,
  css.cell
)
}
\arguments{
\item{rowcells}{The cells with the values that are to be added}

\item{cellcode}{Type of cell, can either be \code{th} or \code{td}}

\item{align}{A character strings specifying column alignments, defaulting to
\code{\link[base]{paste}(rep('c',ncol(x)),collapse='')} to center. Valid alignments are
l = left, c = center and r = right. You can also specify \code{align='c|c'} and
other LaTeX tabular formatting. If you want to set the alignment of the
rownames this string needst to be \code{ncol(x) + 1}, otherwise it automatically
pads the string with a left alignment for the rownames.}

\item{style}{The cell style}

\item{cgroup_spacer_cells}{The number of cells that occur between
columns due to the cgroup arguments.}

\item{has_rn_col}{Due to the alignment issue we need to keep track
of if there has already been printed a rowname column or not and therefore
we have this has_rn_col that is either 0 or 1.}

\item{col.columns}{Alternating colors for each column.}

\item{offset}{For rgroup rows there may be an offset != 1}

\item{css.cell}{The css.cell but only for this row compared to the htmlTable matrix}
}
\value{
\code{string} Returns the string with the new cell elements
}
\description{
Adds a row of cells <td>val</td><td>...</td> to a table string for
\code{\link{htmlTable}}
}
\seealso{
Other hidden helper functions for htmlTable: 
\code{\link{prAddSemicolon2StrEnd}()},
\code{\link{prEscapeHtml}()},
\code{\link{prGetCgroupHeader}()},
\code{\link{prGetRowlabelPos}()},
\code{\link{prGetStyle}()},
\code{\link{prPrepareAlign}()},
\code{\link{prPrepareCgroup}()},
\code{\link{prTblNo}()}
}
\concept{hidden helper functions for htmlTable}
\keyword{internal}
