% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txtFrmt.R
\name{txtMergeLines}
\alias{txtMergeLines}
\title{A merges lines while preserving the line break for HTML/LaTeX}
\usage{
txtMergeLines(..., html = 5)
}
\arguments{
\item{...}{The lines that you want to be joined}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting. Note if you set this to 5
then the HTML5 version of \emph{br} will be used: \verb{<br>}
otherwise it uses the \verb{<br />} that is compatible
with the XHTML-formatting.}
}
\value{
\code{string} with \code{asis_output} wrapping if html output is activated
}
\description{
This function helps you to do a table header with multiple lines
in both HTML and in LaTeX. In HTML this isn't that tricky, you just use
the \verb{<br />} command but in LaTeX I often find
myself writing \code{vbox}/\code{hbox} stuff and therefore
I've created this simple helper function
}
\examples{
txtMergeLines("hello", "world")
txtMergeLines("hello", "world", html=FALSE)
txtMergeLines("hello", "world", list("A list", "is OK"))

}
\seealso{
Other text formatters: 
\code{\link{txtInt}()},
\code{\link{txtPval}()},
\code{\link{txtRound}()}
}
\concept{text formatters}
