% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_render_getCgroupHeader.R
\name{prGetCgroupHeader}
\alias{prGetCgroupHeader}
\title{Retrieve a header row}
\usage{
prGetCgroupHeader(
  x,
  cgroup_vec,
  n.cgroup_vec,
  cgroup_vec.just,
  row_no,
  top_row_style,
  rnames,
  rowlabel = NULL,
  cgroup_spacer_cells,
  style_list,
  prepped_cell_css,
  css_4_cgroup_vec
)
}
\arguments{
\item{x}{The matrix/data.frame with the data. For the \code{print} and \code{knit_print}
it takes a string of the class \code{htmlTable} as \code{x} argument.}

\item{cgroup_vec}{The \code{cgroup} may be a \code{matrix}, this is
just one row of that \code{matrix}}

\item{n.cgroup_vec}{The same as above but for the counter}

\item{cgroup_vec.just}{The same as above bot for the justification}

\item{row_no}{The row number within the header group. Useful for multi-row
headers when we need to output the \code{rowlabel} at the \code{pos.rowlabel}
level.}

\item{top_row_style}{The top row has a special style depending on
the \code{ctable} option in the \code{htmlTable} call.}

\item{rnames}{Default row names are generated from \code{\link[base:colnames]{rownames(x)}}. If you
provide \code{FALSE} then it will skip the row names. \emph{Note:} For \code{data.frames}
if you do \code{\link[base:colnames]{rownames(my_dataframe) <- NULL}} it still has
row names. Thus you need to use \code{FALSE} if you want to
supress row names for \code{data.frames}.}

\item{rowlabel}{If the table has row names or \code{rnames},
\code{rowlabel} is a character string containing the
column heading for the \code{rnames}.}

\item{cgroup_spacer_cells}{The spacer cells due to the multiple cgroup levels.
With multiple rows in cgroup we need to keep track of how many spacer cells
occur between the columns. This variable contains is of the size \code{ncol(x)-1}
and 0 if there is no cgroup element between.}

\item{style_list}{The list with all the styles}
}
\value{
\code{string}
}
\description{
This function retrieves a header row, i.e. a row
within the \verb{<th>} elements on top of the table. Used by
\code{\link[=htmlTable]{htmlTable()}}.
}
\seealso{
Other hidden helper functions for htmlTable: 
\code{\link{prAddCells}()},
\code{\link{prAddEmptySpacerCell}()},
\code{\link{prAddSemicolon2StrEnd}()},
\code{\link{prEscapeHtml}()},
\code{\link{prGetRowlabelPos}()},
\code{\link{prGetStyle}()},
\code{\link{prPrepInputMatrixDimensions}()},
\code{\link{prPrepareAlign}()},
\code{\link{prPrepareCgroup}()},
\code{\link{prTblNo}()}
}
\concept{hidden helper functions for htmlTable}
\keyword{internal}
