% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserFunctions.R
\name{process_input}
\alias{process_input}
\title{Process user input files and obtain options for fitting.}
\usage{
process_input(
  sample_sheet_path = NULL,
  data_file_path = NULL,
  output_file_path = NULL,
  output_pdf = NULL,
  output_csv = NULL,
  error_pdf = NULL,
  num_cores = NULL,
  min_allowed_kd = 10^(-5),
  max_iterations = 1000,
  ptol = 10^(-10),
  ftol = 10^(-10),
  min_RU_tol = 20,
  max_RU_tol = 300
)
}
\arguments{
\item{sample_sheet_path}{The full path to the sample information file.}

\item{data_file_path}{The full path to the titration data file.}

\item{output_file_path}{The full path where output should be stored. This directory needs to exist.}

\item{output_pdf}{The name of the file for the pdf output.}

\item{output_csv}{The name of the file for the csv output.}

\item{error_pdf}{The name of the file for error output.}

\item{num_cores}{The number of cores to use for parallel processing. The default is( the number of cores detected by \code{parallel::detectCores()}.}

\item{min_allowed_kd}{The minimum value for the dissociation constant. The default is 10^(-5).}

\item{max_iterations}{The maximum number of iterations for curve fitting. The default is 1000.}

\item{ptol}{Curve fitting parameter. If the proposed changes in parameters is smaller than this value, the optimization is considered converged. The default is 10^(-10)}

\item{ftol}{Curve fitting parameter. If the squared error between observed and predicted values is smaller than ftol, the optimization is considered converged. The default is 10^(-10)}

\item{min_RU_tol}{Minimum RU required for dissociation window detection}

\item{max_RU_tol}{Maximum RU required for dissociation window detection. Also used in curve fitting.}
}
\value{
A list object containing the following
\item{expanded_sample_sheet}{The sample sheet expanded to include all spots that are represented, expanding the short-hand entries for Position/Block/Channel}
\item{sample_info}{The expanded sample sheet with only the rows that are to be fit}
\item{sample_info_fits}{The sample_info without rows that have encountered errors in initial processing}
\item{Time}{The dataframe whose columns are the Time values for the input titration data. This only includes columns selected for analysis.}
\item{RU}{The dataframe whose columns are the RU values for the input titration data. Only the columns for the samples to be analyzed are included}
\item{correctedRU}{The \code{RU} dataframe after baseline correction}
\item{keep_concentrations}{A vector containing the indices of the columns from \code{Time} and \code{correctedRU} to be used in curve fitting}
\item{all_concentrations_values}{A vector containing the concentration values corresponding to the columns of the \code{Time} and \code{RU} dataframes}
\item{incl_concentrations_values}{A vector containing the concentration values corresponding to the \code{Time} and \code{correctedRU} columns chosen for curve fitting}
\item{n_time_points}{The maximum length of titration time series}
\item{max_RU_tol}{The maximum RU for dissociation window trimming to be automated}
\item{min_RU_tol}{The minimum RU for dissociation window trimming to be automated}
\item{min_RU_tol}{The minimum RU for dissociation window trimming to be automated}
\item{nwells}{The number of rows in the \code{sample_info} dataframe}
\item{n_fit_wells}{The number of rows in the \code{sample_info_fits} dataframe}
\item{ftol}{The ftol parameter passed to the \code{nls.lm} function}
\item{ptol}{The ptol parameter passed to the \code{nls.lm} function}
\item{ptol}{The ptol parameter passed to the \code{nls.lm} function}
\item{output_pdf}{The full pathname for the output pdf file}
\item{output_csv}{The full pathname for the output csv file}
\item{error_pdf}{The full pathname for the pdf error file. This is where errors in processing can be found.}
\item{error_idx_concentrations}{If there is an issue in determining the concentration window for some spots, they will be logged here}
}
\description{
Performs all functions selected in sample information, such as
automated dissociation window detection, automated concentration range, automated bulk shift detection and
returns a list object with the titration time series, processed sample information, all user inputs directing
file outputs and fitting options
}
\examples{
# set up file paths for example

\donttest{ sample_sheet_path <- system.file("extdata",
 "sample_sheet.xlsx", package="htrSPRanalysis")

fn <- paste0("https://gitlab.oit.duke.edu/janice/htrspranalysis/",
        "-/raw/master/inst/extdata/titration_data.xlsx?ref_type=heads")

download.file(fn,
      destfile = paste0(tempdir(),"/titration_data.xlsx"),
      mode = "wb")

data_file_path <- paste0(tempdir(), "/titration_data.xlsx")

# process the input
processed_input <- process_input(sample_sheet_path = sample_sheet_path,
  data_file_path = data_file_path,
   num_cores = 2)}
}
