% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available_rblood2plasma.R
\name{available_rblood2plasma}
\alias{available_rblood2plasma}
\title{Find the best available ratio of the blood to plasma concentration constant.}
\usage{
available_rblood2plasma(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  adjusted.Funbound.plasma = T,
  suppress.messages = F
)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (https://comptox.epa.gov/dashboard)
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{adjusted.Funbound.plasma}{Whether or not to use Funbound.plasma
adjustment if calculating Rblood2plasma.}

\item{suppress.messages}{Whether or not to display relevant warning messages
to user.}
}
\description{
This function finds the best available constant ratio of the blood
concentration to the plasma concentration, using get_rblood2plasma and
calc_rblood2plasma.
}
\details{
Either retrieves a measured blood:plasma concentration ratio from the
chem.physical_and_invitro.data table or calculates it using the red blood cell
partition coefficient predicted with Schmitt's method

If available, in vivo data (from chem.physical_and_invitro.data) for the
given species is returned, substituting the human in vivo value when missing
for other species.  In the absence of in vivo data, the value is calculated
with calc_rblood2plasma for the given species. If Funbound.plasma is
unvailable for the given species, the human Funbound.plasma is substituted.
If none of these are available, the mean human Rblood2plasma from
chem.physical_and_invitro.data is returned.  %% ~~ If necessary, more
details than the description above ~~
}
\examples{

available_rblood2plasma(chem.name="Bisphenol A",adjusted.Funbound.plasma=FALSE)
available_rblood2plasma(chem.name="Bisphenol A",species="Rat")

}
\author{
Robert Pearce
}
\keyword{Parameter}
