% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_gas_pbtk.R
\name{solve_gas_pbtk}
\alias{solve_gas_pbtk}
\title{solve_gas_pbtk}
\usage{
solve_gas_pbtk(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  times = NULL,
  days = 10,
  tsteps = 4,
  daily.dose = NULL,
  doses.per.day = NULL,
  dose = NULL,
  dosing.matrix = NULL,
  forcings = NULL,
  exp.start.time = 0,
  exp.conc = 1,
  period = 24,
  exp.duration = 12,
  fcontrol = list(method = "constant", rule = 2, f = 0),
  initial.values = NULL,
  plots = F,
  suppress.messages = F,
  species = "Human",
  output.units = "uM",
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  default.to.human = F,
  recalc.blood2plasma = F,
  recalc.clearance = F,
  adjusted.Funbound.plasma = T,
  regression = T,
  restrictive.clearance = T,
  minimum.Funbound.plasma = 1e-04,
  monitor.vars = NULL,
  vmax = 0,
  km = 1,
  exercise = F,
  fR = 12,
  VT = 0.75,
  VD = 0.15,
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_gas_pbtk (or other
bespoke) function, overrides chem.name and chem.cas.}

\item{times}{Optional time sequence for specified number of days.  Dosing
sequence begins at the beginning of times.}

\item{days}{Length of the simulation.}

\item{tsteps}{The number of time steps per hour.}

\item{daily.dose}{Total daily dose, mg/kg BW.}

\item{doses.per.day}{Number of doses per day.}

\item{dose}{Amount of a single dose, mg/kg BW.}

\item{dosing.matrix}{Vector of dosing times or a matrix consisting of two
columns or rows named "dose" and "time" containing the time and amount, in
mg/kg BW, of each dose. With the gas pbtk model, dosing.matrix is set to 
specify forcing concentrations to the integrator, either in combination 
with eventdata or on its own.}

\item{forcings}{Manual input of "forcings" data series argument for ode
integrator, defaults to NULL}

\item{exp.start.time}{Start time in specifying forcing exposure series,
default 0.}

\item{exp.conc}{Specified inhalation exposure concentration for use in 
assembling "forcings" data series argument for integrator. Defaults to
uM, in line with output.units}

\item{period}{For use in assembling forcing function data series "forcings"
argument, specified in hours}

\item{exp.duration}{For use in assembling forcing function data 
series 'forcings' argument, specified in hours}

\item{fcontrol}{List of arguments for finetuning inhalation forcing function
in conjunction with existing ode integrator methods}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
output.units.  Defaults are zero.}

\item{plots}{Plots all outputs if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{output.units}{Desired units (either "mg/L", "mg", "umol", or default
"uM").}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical
in the blood to plasma using the input parameters, calculated with
hematocrit, Funbound.plasma, and Krbc2pu.}

\item{recalc.clearance}{Recalculates the hepatic clearance
(Clmetabolism) with new million.cells.per.gliver parameter.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{monitor.vars}{Which variables are returned as a function of time. 
Defaults value of NULL provides "Cgut", "Cliver", "Cven", "Clung", "Cart",
"Crest", "Ckidney", "Cplasma", "Calv", "Cendexh", "Cmixexh", "Cmuc", 
"Atubules", "Ametabolized", "AUC"}

\item{vmax}{Michaelis-Menten vmax value in reactions/min}

\item{km}{Michaelis-Menten concentration of half-maximal reaction velocity
in desired output concentration units.}

\item{exercise}{Logical indicator of whether to simulate an exercise-induced
heightened respiration rate}

\item{fR}{Respiratory frequency (breaths/minute), used especially to adjust
breathing rate in the case of exercise. This parameter, along with VT and VD
(below) gives another option for calculating Qalv (Alveolar ventilation) 
in case pulmonary ventilation rate is not known}

\item{VT}{Tidal volume (L), to be modulated especially as part of simulating
the state of exercise}

\item{VD}{Anatomical dead space (L), to be modulated especially as part of
simulating the state of exercise}

\item{...}{Additional arguments passed to the integrator.}
}
\value{
A matrix of class deSolve with a column for time(in days), each
compartment, the area under the curve, and plasma concentration and a row
for each time point.
}
\description{
This function solves for the amounts or concentrations of a chemical
in different tissues as functions of time as a result of inhalation 
exposure.
}
\details{
The default dosing scheme involves specifying the start time
of exposure, the concentration of gas inhaled, the period of a given 
assumed cycle of exposure, and the duration of the exposure during that 
period. Together, these arguments determine the forcings passed to the 
ODE integrator. The "forcings" can also be specified manually, or 
effectively turned off by setting exposure concentration to zero, if the
user prefers to simulate dosing by other means. 


This function solves for the amounts or concentrations in uM of a chemical
in different tissues as functions of time based on the dose and dosing
frequency. 

Note that the model parameters have units of hours while the model output is
in days.

Default NULL value for doses.per.day solves for a single dose.

The compartments used in this model are the gut lumen, gut, liver, kidneys,
veins, arteries, lungs, and the rest of the body.

The extra compartments include the amounts or concentrations metabolized by
the liver and excreted by the kidneys through the tubules.

AUC is the area under the curve of the plasma concentration.

Model parameters are named according to the following convention:\tabular{lrrrr}{
prefix \tab suffic \tab Meaning \tab units \cr
K \tab \tab Partition coefficient for tissue to free plasma \ tab unitless \cr
V \tab \tab Volume \tab L \cr
Q \tab \tab Flow \tab L/h \cr
k \tab \tab Rate \tab 1/h \cr
\tab c \tab Parameter is proportional to body weight \tab 1 / kg for volumes
and 1/kg^(3/4) for flows \cr}

When species is specified but chemical-specific in vitro data are not
available, the function uses the appropriate physiological data (volumes and 
flows) but default.to.human = TRUE must be used to substitute human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

solve_gas_pbtk(chem.name='Pyrene',dose=.5,days = 3,tsteps=2)

out <- solve_gas_pbtk(chem.name='pyrene',exp.conc = 0, doses.per.day = 2,
daily.dose = 3, plots=TRUE,initial.values=c(Aven=20))

out <- solve_gas_pbtk(chem.name = 'pyrene',exp.conc = 3, period = 24,
exp.duration = 6, exercise = TRUE)
                  
params <- parameterize_gas_pbtk(chem.cas="80-05-7")
solve_gas_pbtk(parameters=params)

}
\references{
Linakis, Matthew W., et al. "Development and Evaluation of a High Throughput 
Inhalation Model for Organic Chemicals", submitted

Pearce, Robert G., et al. "Httk: R package for high-throughput
toxicokinetics." Journal of statistical software 79.4 (2017): 1.
}
\author{
Matt Linakis, John Wambaugh, and Mark Sfeir
}
\keyword{Solve}
