% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armitage.R
\name{armitage_eval}
\alias{armitage_eval}
\title{Evaluate the updated Armitage model}
\usage{
armitage_eval(
  casrn.vector = NA_character_,
  nomconc.vector = 1,
  this.well_number = 384,
  this.FBSf = NA_real_,
  tcdata = NA,
  this.sarea = NA_real_,
  this.v_total = NA_real_,
  this.v_working = NA_real_,
  this.cell_yield = NA_real_,
  this.Tsys = 37,
  this.Tref = 298.15,
  this.option.kbsa2 = F,
  this.option.swat2 = F,
  this.pseudooct = 0.01,
  this.memblip = 0.04,
  this.nlom = 0.2,
  this.P_nlom = 0.035,
  this.P_dom = 0.05,
  this.P_cells = 1,
  this.csalt = 0.15,
  this.celldensity = 1,
  this.cellmass = 3,
  this.f_oc = 1
)
}
\arguments{
\item{casrn.vector}{For vector or single value, CAS number}

\item{nomconc.vector}{For vector or single value, micromolar nominal 
concentration (e.g. AC50 value)}

\item{this.well_number}{For single value, plate format default is 384, used
if is.na(tcdata)==TRUE}

\item{this.FBSf}{Fraction fetal bovine serum, must be entered by user.}

\item{tcdata}{A data.table with casrn, nomconc, MP, gkow, gkaw, gswat, sarea,
v_total, v_working. Otherwise supply single values to this.params.}

\item{this.sarea}{Surface area per well (m^2)}

\item{this.v_total}{Total volume per well (m^3)}

\item{this.v_working}{Working volume per well (m^3)}

\item{this.cell_yield}{Number of cells per well}

\item{this.Tsys}{System temperature (degrees C)}

\item{this.Tref}{Reference temperature (degrees K)}

\item{this.option.kbsa2}{Use alternative bovine-serum-albumin partitioning
model}

\item{this.option.swat2}{Use alternative water solubility correction}

\item{this.pseudooct}{Pseudo-octanol cell storage lipid content}

\item{this.memblip}{Membrane lipid content of cells}

\item{this.nlom}{Structural protein conent of cells}

\item{this.P_nlom}{Proportionality constant to octanol structural protein}

\item{this.P_dom}{Proportionality constant to dissolve organic material}

\item{this.P_cells}{Proportionality constant to octanol storage lipid}

\item{this.csalt}{Ionic strength of buffer, mol/L}

\item{this.celldensity}{Cell density kg/L, g/mL}

\item{this.cellmass}{Mass per cell, ng/cell}

\item{this.f_oc}{1, everything assumed to be like proteins}
}
\value{
\tabular{lll}{
\strong{Column} \tab \strong{Description} \tab \strong{units} \cr
casrn \tab Chemical Abstracts Service Registry Number \tab \cr
nomconc \tab Nominal Concentration \tab mol/L \cr       
well_number \tab Number of wells in plate \tab unitless \cr   
sarea \tab Surface area of well \tab m^2 \cr         
v_total \tab Total volume of well \tab m^3 \cr       
v_working \tab Filled volume of well \tab m^3 \cr     
cell_yield \tab Number of cells \tab cells \cr    
gkow \tab log10 octanol to water partition coefficient (PC)\tab log10 \cr          
logHenry \tab log10 Henry's law constant '\tab log10 atm-m3/mol \cr      
gswat \tab log10 Water solubility \tab log10 mol/L \cr         
MP \tab Melting Point \tab degrees Celsius \cr           
MW \tab Molecular Weight \tab g/mol \cr            
gkaw \tab air to water PC \tab (mol/m3)/(mol/m3) \cr
dsm \tab \tab \cr           
duow \tab \tab \cr          
duaw \tab \tab \cr          
dumw \tab \tab \cr          
gkmw \tab \tab \cr          
gkcw \tab \tab \cr          
gkbsa \tab \tab \cr         
gkpl \tab \tab \cr          
ksalt \tab \tab \cr        
Tsys \tab \tab \cr          
Tref \tab \tab \cr          
option.kbsa2 \tab \tab \cr  
option.swat2 \tab \tab \cr  
FBSf \tab \tab \cr          
pseudooct \tab \tab \cr     
memblip \tab \tab \cr       
nlom \tab \tab \cr          
P_nlom \tab \tab \cr   
P_dom \tab dissolved organic matter to water PC \tab Dimensionless \cr         
P_cells \tab \tab \cr      
csalt \tab \tab \cr         
celldensity \tab \tab \cr   
cellmass \tab \tab \cr      
f_oc \tab \tab \cr          
cellwat \tab \tab \cr       
Tcor \tab \tab \cr          
Vm \tab Volume of media \tab L \cr            
Vwell \tab volume of medium (aqueous phase only) \tab L \cr         
Vair \tab volume of head space \tab L \cr          
Vcells \tab volume of cells/tissue\tab \cr        
Valb \tab volume of serum albumin \tab \cr         
Vslip \tab volume of serum lipids \tab \cr         
Vdom \tab volume of dissolved organic matter\tab \cr          
F_ratio \tab \tab \cr       
gs1.GSE \tab \tab \cr       
s1.GSE \tab \tab \cr        
gss.GSE \tab \tab \cr       
ss.GSE \tab \tab \cr        
kmw \tab \tab \cr           
kow \tab octanol to water PC \tab \cr           
kaw \tab the air towater PC \tab dimensionless \cr           
swat \tab \tab \cr         
kpl \tab \tab \cr           
kcw \tab cell/tissue to water PC \tab dimensionless \cr           
kbsa \tab \tab \cr          
swat_L \tab \tab \cr        
oct_L \tab \tab \cr        
scell_L \tab \tab \cr       
cinit \tab Initial concentration \tab mol \cr         
mtot \tab Total moles \tab mol \cr          
cwat \tab Total concentration in water \tab mol/L \cr          
cwat_s \tab Dissolved concentration in water \tab mol/L \cr        
csat \tab Is the solution saturated (1/0) \tab Boolean \cr         
activity \tab \tab \cr      
cair \tab \tab mol/L \cr          
calb \tab \tab mol/L \cr          
cslip \tab \tab mol/L \cr         
cdom \tab concentration of/in dissolved organic matter\tab mol/L \cr          
ccells \tab \tab mol/L \cr        
cplastic \tab \tab mol/L \cr      
mwat_s \tab Mass dissolved in water \tab mols \cr        
mair \tab Mass in air \tab mols \cr          
mbsa \tab Mass bound to bovine serum albumin \tab mols \cr          
mslip \tab Mass bound to serum lipids \tab mols \cr        
mdom \tab Mass bound to dissolved organic matter \tab mols \cr          
mcells \tab Mass in cells \tab mols \cr        
mplastic \tab Mass bond to plastic \tab mols \cr      
mprecip \tab Mass precipitated out of solution \tab \cr       
xwat_s \tab Fraction dissolved in water \tab fraction \cr        
xair \tab Fraction in the air \tab fraction \cr          
xbsa \tab Fraction bound to bovine serum albumin \tab fraction \cr          
xslip \tab Fraction bound to serum lipids \tab fraction \cr         
xdom \tab Fraction bound to dissolved organic matter \tab fraction \cr          
xcells \tab Fraction within cells \tab fraction \cr        
xplastic \tab Fraction bound to plastic \tab fraction \cr     
xprecip \tab Fraction precipitated out of solution \tab fraction \cr       
eta_free \tab effective availability ratio \tab fraction \cr      
\strong{cfree.invitro} \tab \strong{Free concentration in the in vitro media} (use for Honda1 and Honda2) \tab micromolar \cr
}
}
\description{
Evaluate the Armitage model for chemical distributon in vitro. Takes input
as data table or vectors of values. Outputs a data table. Updates over
the model published in Armitage et al. 2014 include binding to plastic walls
and lipid and protein compartments in cells.
}
\examples{

library(httk)

# Check to see if we have info on the chemical:
"80-05-7" \%in\% get_cheminfo()

#We do:
temp <- armitage_eval(casrn.vector = c("80-05-7", "81-81-2"), this.FBSf = 0.1,
this.well_number = 384, nomconc = 10)
print(temp$cfree.invitro)

# Check to see if we have info on the chemical:
"793-24-8" \%in\% get_cheminfo()

# Since we don't look up phys-chem from dashboard:
cheminfo <- data.frame(
  Compound="6-PPD",
  CASRN="793-24-8",
  DTXSID="DTXSID9025114",
  logP=4.27, 
  logHenry=log10(7.69e-8),
  logWSol=log10(1.58e-4),
  MP=	99.4,
  MW=268.404
  )
  
# Add the information to HTTK's database:
chem.physical_and_invitro.data <- add_chemtable(
 cheminfo,
 current.table=chem.physical_and_invitro.data,
 data.list=list(
 Compound="Compound",
 CAS="CASRN",
  DTXSID="DTXSID",
  MW="MW",
  logP="logP",
  logHenry="logHenry",
  logWSol="logWSol",
  MP="MP"),
  species="Human",
  reference="CompTox Dashboard 31921")

# Run the Armitage et al. (2014) model:
out <- armitage_eval(
  casrn.vector = "793-24-8", 
  this.FBSf = 0.1,
  this.well_number = 384, 
  nomconc = 10)
  
print(out)

}
\references{
Armitage, J. M.; Wania, F.; Arnot, J. A. Environ. Sci. Technol. 
2014, 48, 9770-9779. https://doi.org/10.1021/es501955g

Honda et al. PloS one 14.5 (2019): e0217564. https://doi.org/10.1371/journal.pone.0217564
}
\author{
Greg Honda
}
