% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tissue.data}
\alias{tissue.data}
\title{Tissue composition and species-specific physiology parameters}
\format{
A data.frame containing 13 rows and 20 columns.
}
\source{
Pearce et al. (2017), in preparation,

Wambaugh, John F., et al. "Toxicokinetic triage for environmental
chemicals." Toxicological Sciences (2015): 228-237.
}
\usage{
tissue.data
}
\description{
This data set contains values from Schmitt (2008) and Ruark et al. (2014)
describing the composition of specific tissues and from Birnbaum et al.
(1994) describing volumes of and blood flows to those tissues, allowing
parameterization of toxicokinetic models for human, mouse, rat, dog, or
rabbit. Tissue volumes were calculated by converting the fractional mass of
each tissue with its density (both from ICRP), lumping the remaining tissues
into the rest-of-body, excluding the mass of the gastrointestinal contents
}
\details{
New tissues can be added to this table to generate
their partition coefficients.

The tissue data needed for calculating partition coefficients include: 
cellular and water fractions of 
total volume, lipid and protein  fractions of cellular volume, lipid 
fractions of the total lipid volume, the pH of each tissue,
and the fractional volume of protein in plasma.
}
\examples{
# We can add thyroid to the tissue data by making a row containing
# its data, subtracting the volumes and flows from the rest-of-body, 
# and binding the row to tissue.data. Here we assume it contains the same 
# partition coefficient data as the spleen and a tenth of the volume and  
# blood flow:
new.tissue <- subset(tissue.data,Tissue == "spleen")
new.tissue[, "Tissue"] <- "thyroid"
new.tissue[new.tissue$variable \%in\% c("Vol (L/kg)",
"Flow (mL/min/kg^(3/4))"),"value"] <- new.tissue[new.tissue$variable
\%in\% c("Vol (L/kg)","Flow (mL/min/kg^(3/4))"),"value"] / 10
tissue.data[tissue.data$Tissue == "rest", "value"] <-
tissue.data[tissue.data$Tissue == "rest", "value"] -
new.tissue[new.tissue$variable \%in\% c("Vol (L/kg)",
"Flow (mL/min/kg^(3/4))"),"value"]
tissue.data <- rbind(tissue.data, new.tissue)

}
\references{
Birnbaum, L and Brown, R and Bischoff, K and Foran, J and
Blancato, J and Clewell, H and Dedrick, R (1994). Physiological parameter
values for PBPK model. International Life Sciences Institute, Risk Science
Institute, Washington, DC

Ruark, Christopher D., et al. "Predicting passive and active tissue: plasma
partition coefficients: Interindividual and interspecies variability."
Journal of pharmaceutical sciences 103.7 (2014): 2189-2198.

Schmitt, W. (2008). General approach for the calculation of tissue to plasma
partition coefficients. Toxicology in vitro : an international journal
published in association with BIBRA 22(2), 457-67,
10.1016/j.tiv.2007.09.010.

ICRP. Report of the Task Group on Reference Man. ICRP Publication 23 1975
}
\seealso{
\code{\link{predict_partitioning_schmitt}}
}
\author{
John Wambaugh, Robert Pearce, and Nisha Sipes
}
\keyword{data}
