% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_gas_pbtk.R
\name{solve_gas_pbtk}
\alias{solve_gas_pbtk}
\title{solve_gas_pbtk}
\usage{
solve_gas_pbtk(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  parameters = NULL,
  times = NULL,
  days = 10,
  tsteps = 4,
  daily.dose = NULL,
  doses.per.day = NULL,
  dose = NULL,
  dosing.matrix = NULL,
  forcings = NULL,
  exp.start.time = 0,
  exp.conc = 1,
  period = 24,
  exp.duration = 12,
  initial.values = NULL,
  plots = FALSE,
  suppress.messages = FALSE,
  species = "Human",
  iv.dose = FALSE,
  input.units = "ppmv",
  output.units = NULL,
  default.to.human = FALSE,
  class.exclude = TRUE,
  physchem.exclude = TRUE,
  recalc.blood2plasma = FALSE,
  recalc.clearance = FALSE,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  restrictive.clearance = FALSE,
  minimum.Funbound.plasma = 1e-04,
  monitor.vars = NULL,
  vmax = 0,
  km = 1,
  exercise = FALSE,
  fR = 12,
  VT = 0.75,
  VD = 0.15,
  Caco2.options = list(),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_gas_pbtk (or other
bespoke) function, overrides chem.name and chem.cas.}

\item{times}{Optional time sequence for specified number of days.  Dosing
sequence begins at the beginning of times.}

\item{days}{Length of the simulation.}

\item{tsteps}{The number of time steps per hour.}

\item{daily.dose}{Total daily dose}

\item{doses.per.day}{Number of doses per day.}

\item{dose}{Amount of a single dose}

\item{dosing.matrix}{Vector of dosing times or a matrix consisting of two
columns or rows named "dose" and "time" containing the time and amount of 
each dose.}

\item{forcings}{Manual input of 'forcings' data series argument for ode
integrator. If left unspecified, 'forcings' defaults to NULL, and then other 
input parameters (see exp.start.time, exp.conc, exp.duration, and period)
provide the necessary information to assemble a forcings data series.}

\item{exp.start.time}{Start time in specifying forcing exposure series,
default 0.}

\item{exp.conc}{Specified inhalation exposure concentration for use in 
assembling "forcings" data series argument for integrator. Defaults to
units of ppmv.}

\item{period}{For use in assembling forcing function data series 'forcings'
argument, specified in hours}

\item{exp.duration}{For use in assembling forcing function data 
series 'forcings' argument, specified in hours}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
those specified for the model outputs. Default values are zero.}

\item{plots}{Plots all outputs if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{iv.dose}{Simulates a single i.v. dose if true.}

\item{input.units}{Input units of interest assigned to dosing, including 
forcings. Defaults to "ppmv" as applied to the default forcings scheme.}

\item{output.units}{A named vector of output units expected for the model
results. Default, NULL, returns model results in units specified in the
'modelinfo' file. See table below for details.}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{class.exclude}{Exclude chemical classes identified as outside of 
domain of applicability by relevant modelinfo_[MODEL] file (default TRUE).}

\item{physchem.exclude}{Exclude chemicals on the basis of physico-chemical
properties (currently only Henry's law constant) as specified by 
the relevant modelinfo_[MODEL] file (default TRUE).}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical
in the blood to plasma using the input parameters, calculated with
hematocrit, Funbound.plasma, and Krbc2pu.}

\item{recalc.clearance}{Recalculates the hepatic clearance
(Clmetabolism) with new million.cells.per.gliver parameter.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE. (Default is FALSE.)}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{monitor.vars}{Which variables are returned as a function of time. 
Defaults value of NULL provides "Cgut", "Cliver", "Cven", "Clung", "Cart",
"Crest", "Ckidney", "Cplasma", "Calv", "Cendexh", "Cmixexh", "Cmuc", 
"Atubules", "Ametabolized", "AUC"}

\item{vmax}{Michaelis-Menten vmax value in reactions/min}

\item{km}{Michaelis-Menten concentration of half-maximal reaction velocity
in desired output concentration units.}

\item{exercise}{Logical indicator of whether to simulate an exercise-induced
heightened respiration rate}

\item{fR}{Respiratory frequency (breaths/minute), used especially to adjust
breathing rate in the case of exercise. This parameter, along with VT and VD
(below) gives another option for calculating Qalv (Alveolar ventilation) 
in case pulmonary ventilation rate is not known}

\item{VT}{Tidal volume (L), to be modulated especially as part of simulating
the state of exercise}

\item{VD}{Anatomical dead space (L), to be modulated especially as part of
simulating the state of exercise}

\item{Caco2.options}{A list of options to use when working with Caco2 apical 
to basolateral data \code{Caco2.Pab}, default is Caco2.options = 
list(Caco2.Pab.default = 1.6, Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, 
overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the 
default value for Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE 
uses Caco2.Pab to calculate fabs.oral, otherwise fabs.oral = \code{Fabs}. 
Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE 
overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut 
with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fbio}} for further details.}

\item{...}{Additional arguments passed to the integrator (deSolve).
(Note: There are precision differences between M1 Mac and other OS systems
for this function due to how long doubles are handled. To replicate results
between various OS systems we suggest changing the default method of "lsoda"
to "lsode" and also adding the argument mf = 10.
See [deSolve::ode()] for further details.)}
}
\value{
A matrix of class deSolve with a column for time(in days), each
compartment, the area under the curve, and plasma concentration and a row
for each time point.
}
\description{
This function solves for the amounts or concentrations of a chemical
in different tissues as functions of time as a result of inhalation 
exposure to an ideal gas.
In this PBTK formulation. \eqn{C_{tissue}} is the concentration in tissue at 
time t. Since the perfusion limited partition coefficients describe 
instantaneous equilibrium between the tissue and the free fraction in 
plasma, the whole plasma concentration is 
\eqn{C_{tissue,plasma} = \frac{1}{f_{up}*K_{tissue2fup}}*C_{tissue}}. 
Note that we use a single, 
constant value of \eqn{f_{up}} across all tissues. Corespondingly the free 
plasma 
concentration is modeled as 
\eqn{C_{tissue,free plasma} = \frac{1}{K_{tissue2fup}}*C_tissue}. 
The amount of blood flowing from tissue x is \eqn{Q_{tissue}} (L/h) at a 
concentration 
\eqn{C_{x,blood} = \frac{R_{b2p}}{f_{up}*K_{tissue2fup}}*C_{tissue}}, where 
we use a 
single \eqn{R_{b2p}} value throughout the body.
Metabolic clearance is modelled as being from the total plasma 
concentration here, though it is restricted to the free fraction in 
\code{\link{calc_hep_clearance}} by default. Renal clearance via 
glomerulsr filtration is from the free plasma concentration.
}
\details{
The default dosing scheme involves a specification of the start time
of exposure (exp.start.time), the concentration of gas inhaled (exp.conc),
the period of a cycle of exposure and non-exposure (period), the
duration of the exposure during that period (exp.duration), and the total
days simulated. Together,these arguments determine the "forcings" passed to
the ODE integrator. Forcings can also be specified manually, or effectively
turned off by setting exposure concentration to zero, if the user prefers to 
simulate dosing by other means. 

The "forcings" object is configured to be passed to the integrator with,
at the most, a basic unit conversion among ppmv, mg/L, and uM. No scaling by
BW is set to be performed on the forcings series.

Note that the model parameters have units of hours while the model output is
in days.

Default NULL value for doses.per.day solves for a single dose.

The compartments used in this model are the gut lumen, gut, liver, kidneys,
veins, arteries, lungs, and the rest of the body.

The extra compartments include the amounts or concentrations metabolized by
the liver and excreted by the kidneys through the tubules.

AUC is the area under the curve of the plasma concentration.

Model Figure from \insertCite{linakis2020development}{httk}:
\if{html}{\figure{gaspbtk.jpg}{options: width="100\%" alt="Figure: Gas PBTK 
Model Schematic"}}
\if{latex}{\figure{gaspbtk.pdf}{options: width=12cm alt="Figure: Gas PBTK 
Model Schematic"}}

Model parameters are named according to the following convention:\tabular{lrrrr}{
prefix \tab suffic \tab Meaning \tab units \cr
K \tab \tab Partition coefficient for tissue to free plasma \ tab unitless \cr
V \tab \tab Volume \tab L \cr
Q \tab \tab Flow \tab L/h \cr
k \tab \tab Rate \tab 1/h \cr
\tab c \tab Parameter is proportional to body weight \tab 1 / kg for volumes
and 1/kg^(3/4) for flows \cr}

When species is specified but chemical-specific in vitro data are not
available, the function uses the appropriate physiological data (volumes and 
flows) but default.to.human = TRUE must be used to substitute human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
 
Per- and 
polyfluoroalkyl substances (PFAS) are excluded by default because the 
transporters that often drive PFAS toxicokinetics are not included in this 
model. However, PFAS chemicals can be included with the argument 
"class.exclude = FALSE".
}
\examples{
\donttest{

solve_gas_pbtk(chem.name = 'pyrene', exp.conc = 1, period = 24, expduration = 24)

out <- solve_gas_pbtk(chem.name='pyrene',
                      exp.conc = 0, doses.per.day = 2,
                      daily.dose = 3, input.units = "umol",
                      days=2.5, 
                      plots=TRUE, initial.values=c(Aven=20))

out <- solve_gas_pbtk(chem.name = 'pyrene', exp.conc = 3, 
                      period = 24, days=2.5,
                      exp.duration = 6, exercise = TRUE)
                  
params <- parameterize_gas_pbtk(chem.cas="80-05-7")
solve_gas_pbtk(parameters=params, days=2.5)

# Oral dose with exhalation as a route of elimination:
out <- solve_gas_pbtk(chem.name = 'bisphenol a', exp.conc = 0, dose=100,
                      days=2.5, input.units="mg/kg")

# Note that different model compartments for this model have different units 
# and that the final units can be controlled with the output.units argument:
head(solve_gas_pbtk(chem.name="lindane", days=2.5))
# Convert all compartment units to mg/L:
head(solve_gas_pbtk(chem.name="lindane", days=2.5, output.units="mg/L"))
# Convert just the plasma to mg/L:
head(solve_gas_pbtk(chem.name="lindane", days=2.5, 
                    output.units=list(Cplasma="mg/L")))
}

}
\references{
\insertRef{linakis2020development}{httk}
}
\seealso{
\code{\link{solve_model}}

\code{\link{parameterize_gas_pbtk}}
}
\author{
Matt Linakis, John Wambaugh, Mark Sfeir, Miyuki Breen
}
\keyword{Solve}
