% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ping.R
\name{ping}
\alias{ping}
\title{Ping a url, doing a single call, with any http verbs}
\usage{
ping(url, verb = GET, ...)
}
\arguments{
\item{url}{A url}

\item{verb}{(character) An http verb, default: \code{\link[httr:GET]{httr::GET()}}}

\item{...}{Any \pkg{httr} verb parameters passed on to those functions}
}
\description{
Ping a url, doing a single call, with any http verbs
}
\examples{
\dontrun{
"https://mockbin.com/request" \%>\% ping()
ping("https://mockbin.com/request")
"https://mockbin.com/request" \%>\% ping(config=verbose())
ping("https://mockbin.com/request", config=verbose())
"https://mockbin.com/request" \%>\% ping(config=c(verbose(), accept_json()))

"https://mockbin.com/request" \%>\% ping()
"https://mockbin.com/request" \%>\% ping(verb=HEAD)
"https://mockbin.com/request" \%>\% ping(verb=PUT)
"https://google.com" \%>\% ping()

# pass just a port number, tries to resolve, fails if not found
# "9200" \%>\% ping()
# 9200 \%>\% ping()
# 9200 \%>\% ping(verb=POST)
# 9200 \%>\% ping(verb=HEAD)
# ping(9200)
# ping("9200")
}
}
