% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/without-internet.R
\name{without_internet}
\alias{without_internet}
\title{Make all HTTP requests raise an error}
\usage{
without_internet(expr)
}
\arguments{
\item{expr}{Code to run inside the mock context}
}
\value{
The result of \code{expr}
}
\description{
\code{without_internet} simulates the situation when any network request will
fail, as in when you are without an internet connection. Any HTTP request
through the verb functions in \code{httr} will raise
an error. The error message raised has a well-defined shape, made of three
elements, separated by space: (1) the request
method (e.g. "GET"); (2) the request URL; and
(3) the request body, if present. The verb-expectation functions,
such as \code{\link[=expect_GET]{expect_GET()}} and \code{\link[=expect_POST]{expect_POST()}}, look for this shape.
}
\examples{
without_internet({
    expect_error(httr::GET("http://httpbin.org/get"),
        "GET http://httpbin.org/get")
    expect_error(httr::PUT("http://httpbin.org/put",
        body='{"a":1}'),
        'PUT http://httpbin.org/put {"a":1}', fixed=TRUE)
})
}
