% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redact.R
\name{gsub_response}
\alias{gsub_response}
\title{Find and replace within a response object}
\usage{
gsub_response(response, pattern, replacement, ...)
}
\arguments{
\item{response}{An \code{httr2_response} or \code{http2_request} object to sanitize.}

\item{pattern}{From \code{\link[base:grep]{base::gsub()}}: "character string containing a regular
expression (or character string for \code{fixed = TRUE}) to be matched in the
given character vector." Passed to \code{gsub()}. See the docs for \code{gsub()} for
further details.}

\item{replacement}{A replacement for the matched pattern, possibly including
regular expression backreferences. Passed to \code{gsub()}. See the docs for
\code{gsub()} for further details.}

\item{...}{Additional logical arguments passed to \code{gsub()}: \code{ignore.case},
\code{perl}, \code{fixed}, and \code{useBytes} are the possible options.}
}
\value{
An \code{httr2_response} object, same as was passed in, with the
pattern replaced in the URLs and bodies.
}
\description{
This function passes its arguments to \code{\link[base:grep]{base::gsub()}} in order to find and
replace string patterns (regular expressions) within
the URL and the response body of \code{httr2_response} objects.
}
\details{
Note that, unlike \code{gsub()}, the first argument of the function is \code{response},
not \code{pattern}, while the equivalent argument in \code{gsub()}, "\code{x}", is placed
third. This difference is to maintain consistency with the other redactor
functions in \code{httptest2}, which all take \code{response} as the first argument.

This function also can be applied to an \code{http2_request} object to replace
patterns inside the request URL.
}
