% Generated by roxygen2 (4.0.1): do not edit by hand
\name{add_headers}
\alias{add_headers}
\title{Add additional headers to a request.}
\usage{
add_headers(..., .headers = character())
}
\arguments{
\item{...}{named header values.  To stop an existing header from being
set, pass an empty string: \code{""}.}

\item{.headers}{a named character vector}
}
\description{
Wikipedia provides a useful list of common http headers:
\url{http://en.wikipedia.org/wiki/List_of_HTTP_header_fields}.
}
\examples{
add_headers(a = 1, b = 2)
add_headers(.headers = c(a = "1", b = "2"))

GET("http://httpbin.org/headers")

# Add arbitrary headers
GET("http://httpbin.org/headers",
 add_headers(version = version$version.string))

# Override default headers with empty strings
GET("http://httpbin.org/headers", add_headers(Accept = ""))
}
\seealso{
\code{\link{accept}} and \code{\link{content_type}} for
  convenience functions for setting accept and content-type headers.

Other config: \code{\link{authenticate}};
  \code{\link{config}}; \code{\link{set_cookies}};
  \code{\link{timeout}}; \code{\link{use_proxy}};
  \code{\link{user_agent}}; \code{\link{verbose}}
}

