% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.r
\name{config}
\alias{config}
\title{Set curl options.}
\usage{
config(..., token = NULL)
}
\arguments{
\item{...}{named Curl options.}

\item{token}{An OAuth token (1.0 or 2.0)}
}
\description{
Generally you should only need to use this function to set CURL options
directly if there isn't already a helpful wrapper function, like
\code{\link{set_cookies}}, \code{\link{add_headers}} or
\code{\link{authenticate}}. To use this function effectively requires
some knowledge of CURL, and CURL options. Use \code{\link{httr_options}} to
see a complete list of available options. To see the libcurl documentation
for a given option, use \code{\link{curl_docs}}.
}
\details{
Unlike Curl (and RCurl), all configuration options are per request, not
per handle.
}
\examples{
# There are a number of ways to modify the configuration of a request
# * you can add directly to a request
HEAD("https://www.google.com", verbose())

# * you can wrap with with_config()
with_config(verbose(), HEAD("https://www.google.com"))

# * you can set global with set_config()
old <- set_config(verbose())
HEAD("https://www.google.com")
# and re-establish the previous settings with
set_config(old, override = TRUE)
HEAD("https://www.google.com")
# or
reset_config()
HEAD("https://www.google.com")

# If available, you should use a friendly httr wrapper over RCurl
# options. But you can pass Curl options (as listed in httr_options())
# in config
HEAD("https://www.google.com/", config(verbose = TRUE))
}
\seealso{
\code{\link{set_config}} to set global config defaults, and
 \code{\link{with_config}} to temporarily run code with set options.

All known available options are listed in \code{\link{httr_options}}

Other config: \code{\link{add_headers}},
  \code{\link{authenticate}}, \code{\link{set_cookies}},
  \code{\link{timeout}}, \code{\link{use_proxy}},
  \code{\link{user_agent}}, \code{\link{verbose}}

Other ways to set configuration: \code{\link{set_config}},
  \code{\link{with_config}}
}
