% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform.R
\name{req_perform}
\alias{req_perform}
\title{Perform a request}
\usage{
req_perform(
  req,
  path = NULL,
  verbosity = getOption("httr2_verbosity", 0L),
  mock = getOption("httr2_mock", NULL)
)
}
\arguments{
\item{req}{A \link{request}.}

\item{path}{Optionally, path to save body of request. This is useful for
large responses since it avoids storing the response in memory.}

\item{verbosity}{How much information to print? This is a wrapper
around \code{req_verbose()} that uses an integer to control verbosity:
\itemize{
\item 0: no output
\item 1: show headers
\item 2: show headers and bodies
\item 3: show headers, bodies, and curl status messages.
}}

\item{mock}{A mocking function. If supplied, this function is called
with the request. It should return either \code{NULL} (if it doesn't want to
handle the request) or a \link{response} (if it does). See \code{\link[=with_mock]{with_mock()}}/
\code{local_mock()} for more details.}
}
\value{
If request is successful (i.e. the request was successfully
performed and a response with HTTP status code <400 was recieved), an HTTP
\link{response}; otherwise throws an error. Override this behaviour with
\code{\link[=req_error]{req_error()}}.
}
\description{
After preparing a \link{request}, call \code{req_perform()} to perform it, fetching
the results back to R as a \link{response}.
}
\section{Requests}{
Note that one call to \code{req_perform()} may perform multiple HTTP requests:
\itemize{
\item If the \code{url} is redirected with a 301, 302, 303, or 307, curl will
automatically follow the \code{Location} header to the new location.
\item If you have configured retries with \code{\link[=req_retry]{req_retry()}} and the request
fails with a transient problem, \code{req_perform()} will try again after
waiting a bit. See \code{\link[=req_retry]{req_retry()}} for details.
\item If you are using OAuth, and the cached token has expired, \code{req_perform()}
will get a new token either using the refresh token (if available)
or by running the OAuth flow.
}
}

\examples{
request("https://google.com") \%>\%
  req_perform()
}
