% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-password.R
\name{oauth_flow_password}
\alias{oauth_flow_password}
\title{OAuth flow: user password}
\usage{
oauth_flow_password(
  client,
  username,
  password = NULL,
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{username}{User name.}

\item{password}{Password. You avoid entering the password directly when
calling this function as it will be captured by \code{.Rhistory}. Instead,
leave it unset and the default behaviour will prompt you for it
interactively.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
This function implements the OAuth resource owner password flow, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.3}{rfc6749},
Section 4.3. It allows the user to supply their password once, exchanging
it for an access token that can be cached locally.
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_device}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
