% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{ChipInfo}
\alias{ChipInfo}
\title{Constructor (wrapper) for ChipInfo annotation object}
\usage{
ChipInfo(GRanges = NULL, chr = NULL, pos = NULL, ids = NULL,
  chip = "unknown chip", build = "", rs.id = NULL, chip.id = NULL,
  A1 = NULL, A2 = NULL, QCcode = NULL)
}
\arguments{
\item{GRanges}{a GRanges object containing chromosome, start/end = position, and strand
information for the chip object to be created, also rownames should be used to code
the chip-ids for each SNP.}

\item{chr}{optional, alternative to using 'GRanges' to input SNP locations, enter here 
a vector of chromosome numbers/letters for each SNP. The recommended coding is: 
1:22, X, Y, XY, MT}

\item{pos}{optional, vector of positions (integers), use in conjunction with 'chr' and
'ids' as an alternative way to input SNP position information instead of GRanges.}

\item{ids}{optional, vector of SNP chip-ids, use in conjunction with 'chr' and
'pos' as an alternative way to input SNP position information instead of GRanges.}

\item{chip}{character, name of the chip you are making this annotation for (only used
for labelling purposes)}

\item{build}{character, either "hg18" or "hg19". Will also accept build number, 36 or 37.
This indicates what coordinates the object is using, and will be taken into account by
conversion functions, and annotation lookup functions throughout this package.}

\item{rs.id}{'rs' ids are standardized ids for SNPs, these usually differ from each chips'
own IDs for each snp. If you don't know these, or can't find them, they can be left blank,
but will render the functions 'rs.to.id()' and 'id.to.rs()' useless for this ChipInfo object.}

\item{chip.id}{chip ids are the chip-specific ids for SNPs, these usually differ between chips'
even for the same snp. If you don't know these, or can't find them, they can be left blank,
but will render the function 'chip.id()' useless for this ChipInfo object. The main purpose
of this parameter is for when the real chip ids are not valid R row/column name strings, and
by using this column, some functions can return the real chip ids instead of the sanitized 
version}

\item{A1}{the first allele letter code for each SNP, e.g, usually "A","C","G", or "T", but
you can use any scheme you like. Can be left blank.}

\item{A2, }{as for A1, but for allele 2.}

\item{QCcode}{optional column to keep track of SNPs passing and failing QC. You can completely
ignore this column. It works based on integer codes, 0,1,2, you may wish to use simple 0 and 1,
for pass and fail respectively, or else 0 can be pass, and 1,2,... can indicate failure for 
different criteria. 0 will always be treated as a pass and anything else as a fail, so you
can code fails however you wish.}
}
\description{
This class annotates a microarray SNP chip with data for each SNP including chromosome,
id, position, strand, 'rs' id, allele 1, allele 2 for each SNP of a microarray chip,
in either hg18, hg19 or hg38 (build 36/37/38) coordinates.
This package makes extension use of this class of annotation object for the working
microarray chip, e.g, default is ImmunoChip, but Metabochip is also built-in,
and you can also load your own annotation if using a different chip. The class
is basically a GRanges object, modified to always have columns for A1, A2 (alleles), 
rs.id, and a quality control flag. The default display is tidier than GRanges, it has
nice coersion to and frame data.frame and subsetting by chromosome using [[n]] has been
added, in addition to normal [i,j] indexing native to GRanges.
}

