% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{SH}
\alias{SH}
\title{calculate specific humidity}
\usage{
SH(e, p = 101325)
}
\arguments{
\item{e}{partial water vapor pressure in Pascal (Pa)}

\item{p}{atmospheric pressure in Pascal (Pa). The default is standard atmospheric pressure of 101325Pa.}
}
\value{
numeric specific humidity \eqn{q} (\eqn{kg/kg})
}
\description{
calculate specific humidity \eqn{q} based on partial water vapor pressure \eqn{e} under given atmospheric pressure \eqn{p}
}
\examples{
\dontrun{
t <- 273.15
Es <- SVP(t)
e <- WVP(70, Es)
SH(e, p = 101325)
}
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Center for Earth System Science, Tsinghua University
}
\seealso{
\code{\link{WVP}}, \code{\link{AH}}, \code{\link{MR}}.
}

