% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hunspell.R
\name{hunspell_check}
\alias{hunspell}
\alias{hunspell_analyze}
\alias{hunspell_check}
\alias{hunspell_find}
\alias{hunspell_stem}
\alias{hunspell_suggest}
\title{Hunspell Spell Checking}
\usage{
hunspell_check(words, ignore = character(), lang = "en_US")

hunspell_find(text, ignore = character(), delim = " .!?:;,.",
  lang = "en_US")

hunspell_suggest(words, lang = "en_US")

hunspell_analyze(words, lang = "en_US")

hunspell_stem(words, lang = "en_US")
}
\arguments{
\item{words}{character vector with individual words to spellcheck}

\item{ignore}{character vector with additional approved words dictionary}

\item{lang}{which dictionary to use. Currently only \code{en_US} is supported}

\item{text}{character vector with arbitrary length text}

\item{delim}{string with characters used to deliminate words}
}
\description{
Various tools for spell checking. The \code{\link{hunspell_check}} function
takes a vector of words and tests each individual word for correctness. The
\code{\link{hunspell_find}} function takes a character vector with text
(sentences) and returns only incorrect words. Finally \code{\link{hunspell_suggest}}
is used to suggest correct words for each (incorrect) input word.
}
\details{
The functions \code{\link{hunspell_analyze}} and \code{\link{hunspell_stem}}
try to break down a word and return it's structure or stem word(s).

Currently only US english dictionary is included with the package. Additional
dictrionaries can be downloaded from an OpenOffice
\href{http://ftp.snt.utwente.nl/pub/software/openoffice/contrib/dictionaries/}{mirror}
or \href{http://archive.ubuntu.com/ubuntu/pool/main/libr/libreoffice-dictionaries/?C=S;O=D}{bundle}.
}
\examples{
#check individual words
words <- c("beer", "wiskey", "wine")
correct <- hunspell_check(words)
print(correct)

# find suggestions for incorrect words
hunspell_suggest(words[!correct])

# find incorrect words in piece of text
bad <- hunspell_find("spell checkers are not neccessairy for langauge ninja's")
print(bad)
hunspell_suggest(bad)
}

