% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_storm_data.R
\name{filter_wind_data}
\alias{filter_wind_data}
\title{Filter hurricane wind dataset}
\usage{
filter_wind_data(counties = NULL, storm = NULL, year_range = NULL,
  wind_limit = NULL, output_vars = "fips", wind_var = "vmax_sust",
  wind_source = "modeled")
}
\arguments{
\item{counties}{A character vector listing all 5-digit county FIPS codes
for a subset of counties.}

\item{storm}{A character string giving the storm ID (e.g., "Floyd-1999")}

\item{year_range}{A numeric vector of length two with the starting and
ending year to subset to.}

\item{wind_limit}{A numeric vector of length one giving the minimum
wind speed (in meters per second) or duration of winds of 20 m / s or more
(in minutes) to use in the filter. The units of this variable will depend on
the user's choice for the \code{wind_var} parameter. If the Extended Best
Tracks wind radii are used as the source of the wind data, the sustained
winds will only be available for cutpoints of 34 knots, 50 knots, and 64
knots, so these values should be used (e.g., to get all counties with winds of
34 knots or higher, you could use \code{wind_limit = 17.4}, with the limit
given as a value just below 34 knots in the units meters per second).}

\item{output_vars}{A character vector listing all the columns to include
in the output.}

\item{wind_var}{A character string giving the wind variable to use. Choices
are \code{"vmax_sust"} (maximum sustained winds; default), \code{"vmax_gust"}
(maximum gust winds), \code{"sust_dur"} (minutes of sustained winds of 20 m / s
or higher) and \code{"gust_dur"} (minutes of gust winds of 20 m / s or higher).
If the Extended Best Tracks wind radii are used as the source of wind data,
the \code{"gust_dur"} option cannot be selected.}

\item{wind_source}{A character string specifying the source to use for the winds. Options
are \code{"modeled"}, for estimates based on running a wind model from Best
Tracks data inputs, and \code{"ext_tracks"}, for estimates based on
the wind radii in the Extended Best Tracks data. See the help files for the
datasets \code{storm_winds} and \code{ext_tracks_wind} in the
\code{hurricaneexposuredata} package for more details on each of these sources
for wind estimates. For the gust wind estimates, these are based on applying
a gust factor of 1.49 to the sustained wind estimates in both wind data sources.}
}
\value{
A dataframe with storms filtered based on the input criteria to the
   function. Columns in the output will vary depending on the user's
   selections for the \code{output_vars} argument.
}
\description{
This function is a helper function for many of the the other functions in
this package that measure wind exposure.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

filter_wind_data(counties = c("22071", "51700"), year_range = c(1988, 2011),
                 wind_limit = 20,
                 output_vars = c("fips", "storm_id", "vmax_sust"))
}
}

