% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_other.R
\name{mutate_other}
\alias{mutate_other}
\title{Group infrequent entries into 'Other category'}
\usage{
mutate_other(
  .data,
  var,
  n = 5,
  count,
  by = NULL,
  var.weight = NULL,
  mass = NULL,
  copy = TRUE,
  other.category = "Other"
)
}
\arguments{
\item{.data}{Data containing variable.}

\item{var}{Variable containing infrequent entries, to be collapsed into "Other".}

\item{n}{Threshold for total number of categories above "Other".}

\item{count}{Threshold for total count of observations before "Other".}

\item{by}{Extra variables to group by when calculating \code{n} or \code{count}.}

\item{var.weight}{Variable to act as a weight: \code{var}'s where the sum of this variable exceeds 
\code{mass} will be kept, others set to \code{other.category}.}

\item{mass}{Threshold for sum of \code{var.weight}: any \code{var} where the aggregated sum of \code{var.weight} exceeds \code{mass} will be kept and other \code{var} will be set to \code{other.category}. By default (\code{mass = NULL}), 
the value of \code{mass} is \eqn{-\infty}, with a warning. You may set it explicitly to \code{-Inf} if you really want to avoid a warning that this function will have no effect.}

\item{copy}{Should \code{.data} be copied? Currently only \code{TRUE} is supported.}

\item{other.category}{Value that infrequent entries are to be collapsed into. Defaults to \code{"Other"}.}
}
\value{
\code{.data} but with \code{var} changed so that infrequent values have the same value (\code{other.category}).
}
\description{
Useful when you want to constrain the number of unique values in a column by keeping only the most common values.
}
\examples{
library(data.table)
library(magrittr)

DT <- data.table(City = c("A", "A", "B", "B", "C", "D"),
                 value = c(1, 9, 4, 4, 5, 11))

DT \%>\%
  mutate_other("City", var.weight = "value", mass = 10) \%>\%
  .[]
  
}
