% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearing.R
\name{bearing}
\alias{bearing}
\alias{compass2bearing}
\alias{easterly_component}
\alias{northerly_component}
\title{Bearing calculations}
\usage{
bearing(lat_orig, lon_orig, lat_dest, lon_dest)

compass2bearing(compass)

easterly_component(compass)

northerly_component(compass)
}
\arguments{
\item{lat_orig, lon_orig, lat_dest, lon_dest}{Latitude and longitude
of origin and destination.}

\item{compass}{A character vector of compass rose points, such as 
\code{c("NW", "E", "SSW")}.}
}
\value{
\describe{
\item{\code{bearing}}{An approximate bearing from \code{_orig} and \code{_dest}.}
\item{\code{compass2bearing}}{The bearing encoded by the compass input.}
\item{\code{easterly_component}}{The easterly component of a unit vector
pointing in the direction provided.}
}
}
\description{
Bearing calculations
}
\examples{
bearing(0, 0, 90, 0)
bearing(-35, 151, 51, 0)

compass2bearing("NW")
easterly_component("E")
easterly_component("NW")


}
