% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{col_width}
\alias{col_width}
\alias{col_width<-}
\alias{set_col_width}
\alias{col_width.huxtable}
\alias{col_width<-.huxtable}
\title{Column widths}
\usage{
col_width(ht)
col_width(ht) <- value
set_col_width(ht, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector. If numeric, they are treated as proportions of the table width. If character, they must be valid CSS or LaTeX lengths.}

\item{col}{A col specifier. See \code{\link{rowspecs}} for details.}
}
\value{
For \code{col_width}, the \code{col_width} attribute.
For \code{set_col_width}, the \code{ht} object.
}
\description{
Functions to get or set the column widths property of huxtable cols.
}
\details{
In LaTeX, if you specify a column width, but set \code{wrap} to \code{FALSE} and have cells which
overrun, then you may have problems with table position and with background colours in other cells.
The workaround is to adjust the width, so that your cells no longer overrun.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
col_width(ht) <-  c(.2, .8)
col_width(ht)
print_screen(ht)
}
\seealso{
Other row/column heights: \code{\link{row_height}}
}
\concept{row/column heights}
