% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation.R
\name{insert_column}
\alias{insert_column}
\alias{insert_row}
\title{Insert a row or column}
\usage{
insert_column(ht, ..., after = 0, copy_cell_props = TRUE)

insert_row(ht, ..., after = 0, copy_cell_props = TRUE)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Cell contents.}

\item{after}{Insert the row/column after this position. 0 (the default) inserts as the first row/column.}

\item{copy_cell_props}{Copy cell properties from the previous row or column (if after > 0). See \code{\link[=cbind.huxtable]{cbind.huxtable()}}.}
}
\value{
The modified huxtable
}
\description{
These convenience functions wrap \code{cbind} or \code{rbind} for huxtables to insert
a single row.
}
\details{
In \code{insert_column} only, you can use a column name for \code{after}.
}
\examples{
ht <- hux(a = 1:5, b = 1:5, c = 1:5)
insert_row(ht, 2.5, 2.5, 2.5, after = 2)
insert_column(ht, 5:1)
insert_column(ht, 5:1, after = 3)
insert_column(ht, 5:1, after = "b")
}
\seealso{
\code{\link[=add_rows]{add_rows()}} and \code{\link[=add_columns]{add_columns()}}, which insert multiple rows/columns at once.
}
