% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{escape_contents}
\alias{escape_contents}
\alias{escape_contents<-}
\alias{set_escape_contents}
\alias{map_escape_contents}
\title{Escape cell contents}
\usage{
escape_contents(ht)
escape_contents(ht) <- value
set_escape_contents(ht, row, col, value, byrow = FALSE)
map_escape_contents(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix. If \code{TRUE}, cell contents will be HTML or LaTeX escaped.

Set to \code{NA} to reset to the default, which is \code{TRUE}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{escape_contents}, the \code{escape_contents} property.
For \code{set_escape_contents} and \code{map_escape_contents}, the modified huxtable.
}
\description{
Functions to get or set the \emph{escape cell contents} property of huxtable cells.
}
\examples{
ht <- huxtable(
        Exponent = 2:4,
        Example  = paste0("$x^", 2:4, "$"),
        add_colnames = TRUE
      )
escape_contents(ht)[,2] <- FALSE
\dontrun{
  quick_pdf(ht)
}


jams2 <- set_escape_contents(jams,
      TRUE)
escape_contents(jams2)

jams3 <- set_escape_contents(jams,
      2:3, 1, TRUE)
escape_contents(jams3)

jams4 <- map_escape_contents(jams,
      by_rows(
        TRUE,
        FALSE)
      )
escape_contents(jams4)
}
