% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-docs.R
\docType{package}
\name{huxtable-FAQ}
\alias{huxtable-FAQ}
\title{Frequently Asked Questions, including how to get help}
\description{
A FAQ of common issues.
}
\details{
\itemize{
\item I get a LaTeX error when I try to compile my document!

Have you installed the LaTeX packages you need? LaTeX packages are different
from R packages. Run \code{\link[=check_latex_dependencies]{check_latex_dependencies()}} to find out if you are
missing any. Then install them using your system's LaTeX management
application. Or you can try \code{\link[=install_latex_dependencies]{install_latex_dependencies()}}.

In some rmarkdown and LaTeX formats, you also need to add LaTeX dependencies
manually. Run \code{\link[=report_latex_dependencies]{report_latex_dependencies()}} and add
the output to your LaTeX preamble, or in Rmarkdown formats, add it to the
rmarkdown header like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{header-includes:
  - \\usepackage\{array\}
  - \\usepackage\{caption\}
  ... et cetera
}\if{html}{\out{</div>}}
\item Huxtable isn't working in my Rmarkdown \code{beamer_presentation} slides.

You may need to set the beamer "fragile" option, like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Slide title \{.fragile\}
}\if{html}{\out{</div>}}
\item Numbers in my cells look weird!

You can change numeric formatting using \code{\link[=number_format]{number_format()}}. Base R options
like \code{\link[base:options]{scipen}} usually have no effect.
\item How can I use HTML, TeX etc. in my table?

Use \code{\link[=escape_contents]{escape_contents()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{jams |>
     add_footnote("These jams are <i>tasty</i>!") |>
     set_escape_contents(final(1), everywhere, FALSE) |>
     quick_html()
}\if{html}{\out{</div>}}

Alternatively you might consider using markdown in cells, with
\code{\link[=set_markdown_contents]{set_markdown_contents()}}.
\item I ran \code{caption(ht) <- "Something"} and got an error message:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Error in UseMethod("caption<-") :
no applicable method for 'caption<-' applied to an object of class "c('huxtable',   'data.frame')"
}\if{html}{\out{</div>}}

You may have loaded another package with a \code{caption} method, e.g. "xtable".
Try loading huxtable after xtable.
\item How can I get line breaks in my cells?

Just insert a line break \code{"\\n"} in the cell contents. Then make sure that
\code{\link[=width]{width()}} is set and \code{\link[=wrap]{wrap()}} is \code{TRUE} (it is by default).
\item How can I change the font size, font etc. of captions?

There are no direct commands for this. You have to use raw HTML/TeX/other
commands within the caption itself. For example to have a bold caption in
HTML, you might do something like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{set_caption(jams, "<b>Jam Prices</b>")
}\if{html}{\out{</div>}}
\item How do I refer to tables in bookdown?

As of version 4.3.0, this is handled automatically for you. Just
set the label using \code{\link[=label]{label()}}, then in markdown text do e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\\@ref(tab:my-table-label).

}\if{html}{\out{</div>}}
\item I called \code{library(huxtable)} and now my \code{data.table} objects are getting
printed!

Set \code{options(huxtable.knit_print_df = FALSE)}.
\item How can I set a property on an arbitrary group of cells?

If you can't use the \link{mapping-functions} interface, and you want to
set a property for multiple cells that aren't all in the same rows
and/or columns, you could use a little-known fact about R subsetting.
If you subset \code{ht[x]} where \code{x} is two-column numeric matrix, then
each row of \code{x} indexes a single \verb{(row, column)} cell. So, for example,
here's how to set the background color of cells \verb{(2,1)}, \verb{(1, 3)} and
\verb{(4, 2)} of a huxtable:

\if{html}{\out{<div class="sourceCode">}}\preformatted{indices <- matrix(c(2, 1, 1, 3, 4, 2), ncol = 2, byrow = TRUE)
background_color(jams)[indices] <- "orange"
}\if{html}{\out{</div>}}

Another useful trick sets properties on the diagonal, using \code{\link[=diag]{diag()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{diag(background_color(jams)) <- "grey"
}\if{html}{\out{</div>}}
\item I have another problem.

If you have a bug - i.e. there is something wrong with the software -
or a feature request, please report it to
\url{https://github.com/hughjonesd/huxtable/issues}.
Otherwise, ask a question on \href{https://stackoverflow.com}{StackOverflow} or
\url{https://community.rstudio.com}. That way, other people will benefit from
the answers you get.
\item Can I email you directly?

I'd rather you asked on a public website. If you then email me a link, I
may be able to help.
}
}
