% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ts_bands}
\alias{ts_bands}
\title{Get simultaneous confidence bands for a uniform QQ-plot}
\usage{
ts_bands(n, nsamp = 1000, a = 0.05)
}
\arguments{
\item{n}{Sample size.}

\item{nsamp}{Number of simulation repetitions.}

\item{a}{The significance level.}
}
\value{
A list of length 3. The \code{$lower} and \code{$upper} confidence
limits at uniform quantiles \code{$q}.
}
\description{
This will provide 100(1-a)\% simultaneous confidence bands for a
sample of size \code{n}. It does this by the "tail-sensitive" approach
of Aldor-Noiman et al (2013), which uses simulated uniform vectors. The
number of simulations is controlled by \code{nsamp}.
}
\details{
The procedure used is described in Aldor-Noiman et al (2013). But note
that they have a mistake in their paper. Step (e) of their algorithm on
page 254 should be the CDF of the Beta distribution, not the quantile
function.
}
\examples{
ts <- ts_bands(100)

graphics::plot(x = ts$q,
               y = ts$upper,
               type = "l",
               xlim = c(0, 1),
               ylim = c(0, 1),
               xlab = "Theoretical Quantiles",
               ylab = "Empirical Quantiles")
graphics::lines(x = ts$q, y = ts$lower)
graphics::lines(x = ts$q, y = ts$q, lty = 2)

}
\references{
\itemize{
\item{Aldor-Noiman, S., Brown, L. D., Buja, A., Rolke, W., & Stine, R. A. (2013). The power to see: A new graphical test of normality. The American Statistician, 67(4), 249-260.}
}
}
\author{
David Gerard
}
