% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEvents.R
\name{plotEvents}
\alias{plotEvents}
\title{Plot Events}
\usage{
plotEvents(
  data,
  dates = NULL,
  events,
  type = "lineover",
  colline = "red",
  colpnt = "blue",
  colbound = "red",
  ymax = max(data),
  xlab = "",
  ylab = "",
  main = "events"
)
}
\arguments{
\item{data}{The data vector}

\item{dates}{Optional date vector}

\item{events}{Events data frame}

\item{type}{The type of plot (see details)}

\item{colline}{Line colour}

\item{colpnt}{Point colour}

\item{colbound}{Background colour for plot type \code{"bound"}}

\item{ymax}{Maxiumum plot extent in vertical direction}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{main}{Plot title}
}
\value{
No return value.
}
\description{
Wrapper function for plotting identified events.
}
\details{
Three plot types are implemented: \code{"lineover"}, \code{"bound"}, \code{"hyet"}. See examples.
If events contains a column titled "which.max" the maxima are also plotted.
}
\examples{
# Plot events
library(hydroEvents)
BFI_res = eventBaseflow(dataBassRiver)

oldpar <- par(mfrow = c(3, 1), mar = c(3, 2.7, 2, 1))
d = as.Date("1974-06-30") + 0:(length(dataBassRiver)-1)
plotEvents(data = dataBassRiver, dates = d, events = BFI_res, 
type = "lineover", xlab = "Date", ylab = "Flow (ML/day)", 
main = "lineover")
plotEvents(data = dataBassRiver, dates = d, events = BFI_res, 
type = "bound", xlab = "Date", ylab = "Flow (ML/day)", 
main = "bound")
plotEvents(data = dataBassRiver, dates = d, events = BFI_res, 
type = "hyet", xlab = "Date", ylab = "Flow (ML/day)", 
main = "hyet")
par(oldpar)
}
\seealso{
\code{\link{eventBaseflow}} \code{\link{eventMaxima}} \code{\link{eventMinima}} \code{\link{eventPOT}}
}
\keyword{events}
\keyword{plot}
