% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limbs.R
\name{limbs}
\alias{limbs}
\title{Extract rising/falling limbs}
\usage{
limbs(
  data,
  dates = NULL,
  events,
  to.plot = TRUE,
  ymin = min(data),
  ymax = max(data),
  xlab = "",
  ylab = "",
  main = ""
)
}
\arguments{
\item{data}{The data vector (e.g. a streamflow time series)}

\item{dates}{Date variable, default to NULL (inputting data as a simple vector)}

\item{events}{Event extracted}

\item{to.plot}{c(TRUE,FALSE) whether a plot is produced for the limbs}

\item{ymin}{Minimum plot extend in vertical direction}

\item{ymax}{Maximum plot extent in vertical direction}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{main}{Plot title}
}
\value{
Returns indices of start and end of events and the rising/falling limbs within each event
}
\description{
Identify the rising and falling limbs within each event (and optionally plot)
}
\examples{
# Example 1
library(hydroEvents)
qdata = WQ_Q$qdata[[1]]
BF_res = eventBaseflow(qdata$Q_cumecs)
limbs(data = qdata$Q_cumecs, dates = NULL, events = BF_res, main = "with 'eventBaseflow'")
BFI_res = eventBaseflow(dataBassRiver)

# Example 2
library(hydroEvents)
BFI_res = eventBaseflow(dataBassRiver)
d = as.Date("1974-06-30") + 0:(length(dataBassRiver)-1)
limbs(data = dataBassRiver, dates = NULL, events = BFI_res)
limbs(data = dataBassRiver, dates = d, events = BFI_res)
}
\keyword{events}
