% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_hm_name.R
\name{hm_name}
\alias{hm_name}
\alias{hm_name,hydromet_station-method}
\alias{hm_name,hydromet_compact-method}
\title{Set new column names}
\usage{
hm_name(obj, slot_name, col_name)

\S4method{hm_name}{hydromet_station}(obj, slot_name, col_name)

\S4method{hm_name}{hydromet_compact}(obj, slot_name, col_name)
}
\arguments{
\item{obj}{a valid \code{hydromet_compact} class object.}

\item{slot_name}{string with the a valid name.}

\item{col_name}{string vector with new column names.}
}
\value{
The same object but with new column names.
}
\description{
Change slot's column names.
}
\section{Functions}{
\itemize{
\item \code{hm_name,hydromet_station-method}: set new column name for station class

\item \code{hm_name,hydromet_compact-method}: set new column name for compact class
}}

\examples{

# path to all example files
path <- system.file('extdata', package = 'hydrotoolbox')

# we first build the snih station file
guido <-
hm_create() \%>\%
  hm_build(bureau = 'snih', path = path,
           file_name = c('snih_hq_guido.xlsx',
           'snih_qd_guido.xlsx'),
           slot_name = c('hq', 'qd'),
           by = c('none', 'day') )

 guido \%>\% hm_show(slot_name = 'qd')

# now we can change default names
hm_name(obj = guido, slot_name = 'qd',
        col_name = 'q(m3/s)') \%>\%
        hm_show(slot_name = 'qd')

}
