% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_hm_set.R
\name{hm_set}
\alias{hm_set}
\alias{hm_set,hydromet-method}
\alias{hm_set,hydromet_station-method}
\alias{hm_set,hydromet_compact-method}
\title{Set the data of an \code{hydromet} object or its subclass}
\usage{
hm_set(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  basin_area = NULL,
  basin_eff = NULL,
  other_1 = NULL,
  other_2 = NULL,
  ...
)

\S4method{hm_set}{hydromet}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  basin_area = NULL,
  basin_eff = NULL,
  other_1 = NULL,
  other_2 = NULL,
  ...
)

\S4method{hm_set}{hydromet_station}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  basin_area = NULL,
  basin_eff = NULL,
  other_1 = NULL,
  other_2 = NULL,
  hq = NULL,
  hw = NULL,
  qh = NULL,
  qd = NULL,
  qa = NULL,
  qm = NULL,
  wspd = NULL,
  wdir = NULL,
  evap = NULL,
  anem = NULL,
  patm = NULL,
  rh = NULL,
  tair = NULL,
  tmax = NULL,
  tmin = NULL,
  tmean = NULL,
  tsoil = NULL,
  precip = NULL,
  rainfall = NULL,
  swe = NULL,
  hsnow = NULL,
  kin = NULL,
  kout = NULL,
  lin = NULL,
  lout = NULL,
  unvar = NULL
)

\S4method{hm_set}{hydromet_compact}(
  obj = NULL,
  id = NULL,
  agency = NULL,
  station = NULL,
  lat = NULL,
  long = NULL,
  alt = NULL,
  country = NULL,
  province = NULL,
  river = NULL,
  active = NULL,
  basin_area = NULL,
  basin_eff = NULL,
  other_1 = NULL,
  other_2 = NULL,
  compact = NULL
)
}
\arguments{
\item{obj}{an \code{hydromet} or \code{hydromet_XXX} class object.}

\item{id}{ANY. This is the ID assigned by the agency.}

\item{agency}{character. The name of the agency (or institution) that provides the data of the station.}

\item{station}{character. The name of the (hydro)-meteorological station.}

\item{lat}{numeric. Latitude of the station.}

\item{long}{numeric. Longitude of the station}

\item{alt}{numeric. Altitute of the station.}

\item{country}{character. Country where the station is located. Argentina is set as default value.}

\item{province}{character. Name of the province where the station is located. Mendoza is set as default value.}

\item{river}{character. Basin river's name.}

\item{active}{logical. It indicates whether or not the station is currently operated. Default value is \code{TRUE}.}

\item{basin_area}{numeric. The basin area (km2) of the catchment upstream of the gauge.}

\item{basin_eff}{numeric. The effective area (km2) of the basin upstream of the gauge. In Canada, many basins have
variable contributing fractions. In these basins, the effective area of the basin contributes flow to the outlet at
least one year in two.}

\item{other_1}{ANY. It is the first free-to-fill slot in order to give you the chance to write extra information about your
hydro-met station.}

\item{other_2}{ANY. It is the second free-to-fill slot in order to give you the chance to write extra information about your
hydro-met station.}

\item{...}{arguments to be passed to methods. They rely on the slots of the \code{obj} subclass.}

\item{hq}{water-height vs stream-discharge measurements.}

\item{hw}{water level records.}

\item{qh}{hourly mean river discharge.}

\item{qd}{daily mean river discharge.}

\item{qa}{annual river discharge.}

\item{qm}{monthly mean river discharge.}

\item{wspd}{wind speed.}

\item{wdir}{wind direction.}

\item{evap}{pan-evaporation.}

\item{anem}{anemometer wind speed records (usually installed above the pan-evap tank).}

\item{patm}{atmospheric pressure.}

\item{rh}{relative humidity.}

\item{tair}{air temperature (typically recorded at hourly time-step).}

\item{tmax}{daily maximum recorded air temperature.}

\item{tmin}{daily minimum recorded air temperature.}

\item{tmean}{daily mean air temperature.}

\item{tsoil}{soil temperature.}

\item{precip}{total (snow and rain) precipitation records.}

\item{rainfall}{liquid only precipitation measurements.}

\item{swe}{snow water equivalent (typically recorded on snow pillows).}

\item{hsnow}{snow height from ultrasonic devices.}

\item{kin}{incoming short-wave radiation.}

\item{kout}{outgoing short-wave radiation.}

\item{lin}{incoming long-wave radiation.}

\item{lout}{outgoing long-wave radiation.}

\item{unvar}{reserved for non-considered variables.}

\item{compact}{data frame with Date as first column. All other columns are hydro-meteorological variables.}
}
\value{
The hydromet object with the slots set.
}
\description{
With this method you can set (or change) an specific slot value (change the table).
}
\section{Functions}{
\itemize{
\item \code{hm_set(hydromet)}: set method for generic object

\item \code{hm_set(hydromet_station)}: set method for \code{station} object

\item \code{hm_set(hydromet_compact)}: set method for \code{compact} object

}}
\examples{
\dontrun{
# create an hydro-met station
hm_guido <- hm_create(class_name = 'station')

# assign altitude
hm_guido <- hm_set(obj = hm_guido, alt = 2480)

# now we read streamflow - water height measurements
path_file <- system.file('extdata', 'snih_hq_guido.xlsx',
package = 'hydrotoolbox')
guido_hq  <- read_snih(path = path_file, by = 'none',
             out_name = c('h(m)', 'q(m3/s)',
                            'q_coarse_solid(kg/s)',
                            'q_fine_solid(kg/s)') )

# set the new data frame
 # note: you can do it manually but using the hm_build() method
 #       is stromgly recommended
hm_guido <- hm_set(obj = hm_guido, hq = guido_hq)
hm_show(obj = hm_guido)
}

}
