% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan.txt.Witec.R
\name{scan.txt.Witec}
\alias{scan.dat.Witec}
\alias{scan.txt.Witec}
\alias{scan.txt.Witec.Graph}
\title{File Import Witec Raman}
\usage{
scan.txt.Witec(file = stop("filename or connection needed"),
  points.per.line = NULL, lines.per.image = NULL, nwl = NULL,
  remove.zerospc = TRUE, type = c("single", "map"), hdr.label = FALSE,
  hdr.units = FALSE, ..., quiet = TRUE)

scan.dat.Witec(filex = stop("filename or connection needed"),
  filey = sub("-x", "-y", filex), points.per.line = NULL,
  lines.per.image = NULL, type = c("single", "map"), ...,
  quiet = hy.getOption("debuglevel") < 1L)

scan.txt.Witec.Graph(headerfile = stop("filename or connection needed"),
  filex = gsub("Header", "X-Axis", headerfile), filey = gsub("Header",
  "Y-Axis", headerfile), type = c("single", "map"), ..., quiet = TRUE)
}
\arguments{
\item{file}{filename or connection to ASCII file}

\item{points.per.line}{number of spectra in x direction of the map}

\item{lines.per.image}{number of spectra in y direction}

\item{nwl}{is deprecated and will be removed soon. Number of wavelengths is calculated automatically.}

\item{remove.zerospc}{is deprecated and will be removed soon. Use \code{\link{hy.setOptions} (file.remove.emptyspc = TRUE)} instead.}

\item{type}{type of spectra: \code{single} for single spectra (including time series), \code{map} for imaging data.}

\item{hdr.label}{WITec Project exports the spectra names (contain information of map position or number of spectra) within the \code{file}.}

\item{hdr.units}{WITec Project exports the spectra units within the \code{file}.}

\item{..., quiet}{handed to \code{\link[base]{scan}}}

\item{filex}{filename wavelength axis file}

\item{filey}{filename intensity file}

\item{headerfile}{filename or connection to ASCII file with header information}
}
\value{
a hyperSpec object
}
\description{
Import Raman Spectra/Maps from Witec Instrument via ASCII files
}
\details{
\code{scan.txt.Witec} reads Witec ASCII files where the first column gives the wavelength
axes and the other columns the spectra. \code{scan.dat.Witec} reads Witec's ASCII exported data 
which comes in separate files with x and y data.
}
\author{
Claudia Beleites and Marcel Dahms
}
\seealso{
\code{vignette ("fileio")} for more information on file import and

\code{\link{options}} for details on options.
}

