% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{F_beta}
\alias{F_beta}
\title{F_beta}
\usage{
F_beta(pred, truth, beta = 1)
}
\arguments{
\item{pred}{boolean vector of predicted values}

\item{truth}{boolean vector of true values}

\item{beta}{Weighting of yield as compared to precision. Increase beta so that the optimization favors yield, or decrease to favor purity.}
}
\description{
Compute a F_beta score comparing two boolean vectors
}
\examples{
data(Samusik_01_subset)
truth=c(rep(TRUE,40),rep(FALSE,60))
pred=rep(c(TRUE,FALSE),50)
table(pred,truth) ##40\% purity, 50\% yield
#' F_beta(pred=pred,truth=truth,beta=2) ##Closer to yield
F_beta(pred=pred,truth=truth,beta=1.5) ##Closer to yield
F_beta(pred=pred,truth=truth,beta=1) ##Harmonic mean
F_beta(pred=pred,truth=truth,beta=0.75) ##Closer to purity
F_beta(pred=pred,truth=truth,beta=0.5) ##Closer to purity
}
