% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{useHypothesis}
\alias{useHypothesis}
\title{Use hypothesis annotations}
\usage{
useHypothesis(
  openSidebar = TRUE,
  showHighlights = c("whenSidebarOpen", "always", "never"),
  theme = c("classic", "clean"),
  branding = hypothesisBranding(),
  sidebarAppUrl = NULL,
  onLayoutChange = as_json("tryHideHypothesis"),
  services = hypothesisServices(),
  enableExperimentalNewNoteButton = NULL,
  usernameUrl = NULL,
  externalContainerSelector = NULL,
  focus = NULL,
  requestConfigFromFrame = NULL,
  assetRoot = NULL,
  notebookAppUrl = NULL,
  enableShareLinks = FALSE,
  ...
)
}
\arguments{
\item{openSidebar}{Set to TRUE if annotations sidebar should be opened in initial state.}

\item{showHighlights}{Configure when annotated text should be highlighted.
"whenSidebarOpen" highlights content only when annotations sidebar is open (default).
The remaining options are "always" and "never".}

\item{theme}{Annotations sidebar theme. Available options "classic" (default) and "clean".}

\item{branding}{Configure annotations tool branding (e.g. sidebar background).
See \link{hypothesisBranding} for possible options.}

\item{sidebarAppUrl, onLayoutChange, services, enableExperimentalNewNoteButton, usernameUrl, externalContainerSelector, focus, requestConfigFromFrame, assetRoot, notebookAppUrl, enableShareLinks}{Extra
arguments used for external services configuration and assets configuration.
Visit \href{https://h.readthedocs.io/projects/client/en/latest/publishers/config.html}{config} for more details.}

\item{...}{Extra arguments passed to client configuration.}
}
\value{
A list of class 'shiny.tag.list' storing the package JS/CSS dependencies.
}
\description{
Function used to initialize hypothesis annotations in Shiny app or R Markdown document.
}
