% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARfit.R
\name{IARfit}
\alias{IARfit}
\title{Fitted Values of IAR model}
\usage{
IARfit(phi, y, st, standardized = TRUE, zero.mean = TRUE)
}
\arguments{
\item{phi}{Estimated phi parameter by the iAR model.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{standardized}{logical; if TRUE, the array y is standardized; if FALSE, y contains the raw time series}

\item{zero.mean}{logical; if TRUE, the array y has zero mean; if FALSE, y has a mean different from zero.}
}
\value{
Fitted values of the iAR model
}
\description{
Fit an IAR model to an irregularly observed time series.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st,n=100)
y<-y$series
phi=IARloglik(y=y,st=st)$phi
fit=IARfit(phi=phi,y=y,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}, \code{\link{IARloglik}}, \code{\link{IARkalman}}
}
