% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARforecast.R
\name{IARforecast}
\alias{IARforecast}
\title{Forecast from IAR model}
\usage{
IARforecast(phi, y, st, standardized = TRUE, zero.mean = TRUE, tAhead)
}
\arguments{
\item{phi}{Estimated phi parameter by the iAR model.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{standardized}{logical; if TRUE, the array y is standardized; if FALSE, y contains the raw time series}

\item{zero.mean}{logical; if TRUE, the array y has zero mean; if FALSE, y has a mean different from zero.}

\item{tAhead}{The time ahead for forecast is required.}
}
\value{
Forecasted value from the iAR model
}
\description{
Forecast from models fitted by \code{\link{IARloglik}}
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st,n=100)
y<-y$series
n=length(y)
p=trunc(n*0.99)
ytr=y[1:p]
yte=y[(p+1):n]
str=st[1:p]
ste=st[(p+1):n]
tahead=ste-str[p]
phi=IARloglik(y=ytr,st=str)$phi
forIAR=IARforecast(phi=phi,y=ytr,st=str,tAhead=tahead)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}, \code{\link{IARloglik}}, \code{\link{IARkalman}}, \code{\link{IARfit}}
}
