% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARgfit.R
\name{IARgfit}
\alias{IARgfit}
\title{Fitted Values of IAR-Gamma model}
\usage{
IARgfit(phi, mu, y, st)
}
\arguments{
\item{phi}{Estimated phi parameter by the iAR-Gamma model.}

\item{mu}{Estimated mu parameter by the iAR-Gamma model.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}
}
\value{
Fitted values of the iAR-Gamma model
}
\description{
Fit an IAR-Gamma model to an irregularly observed time series.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARgsample(phi=0.9,st=st,n=n,sigma2=1,mu=1)
model<-IARgamma(y$y, st=st)
phi=model$phi
muest=model$mu
sigmaest=model$sigma
fit=IARgfit(phi=phi,mu=muest,y=y$y,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARgsample}}, \code{\link{IARgamma}}
}
