# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fitted Values of BiAR model
#'
#' Fit a BiAR model to a bivariate irregularly observed time series.
#'
#' @param coef An array with the parameters of the BiAR model. The elements of the array are, in order, the autocorrelation and the cross correlation parameter of the BiAR model.
#' @param series1 Array with the observations of the first time series of the BiAR process.
#' @param series2 Array with the observations of the second time series of the BiAR process.
#' @param times Array with the irregular observational times.
#' @param series_esd1 Array with the measurements error standard deviations of the first time series of the BiAR process.
#' @param series_esd2 Array with the measurements error standard deviations of the second time series of the BiAR process.
#' @param zero_mean logical; if TRUE, the array y has zero mean; if FALSE, y has a mean different from zero.
#'
#' @return A list with the following components:
#' \itemize{
#' \item{rho}{ Estimated value of the contemporary correlation coefficient.}
#' \item{innov.var}{ Estimated value of the innovation variance.}
#' \item{fitted}{ Fitted values of the BiAR model.}
#' \item{fitted.state}{ Fitted state values of the BiAR model.}
#' \item{Lambda}{ Lambda value estimated by the BiAR model at the last time point.}
#' \item{Theta}{ Theta array estimated by the BiAR model at the last time point.}
#' \item{Sighat}{ Covariance matrix estimated by the BiAR model at the last time point.}
#' \item{Qt}{ Covariance matrix of the state equation estimated by the BiAR model at the last time point.}
#' }
#' @references
#' \insertRef{Elorrieta_2021}{iAR}
#' @seealso
#' \code{\link{gentime}}, \code{\link{BiARsample}}, \code{\link{BiARphikalman}}, \code{\link{BiARkalman}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=80
#' set.seed(6714)
#' st<-gentime(n)
#' x=BiARsample(phiR=0.9,phiI=0.3,times=st,rho=0.9)
#' y=x$series
#' y1=y/apply(y,1,sd)
#' yerr1=rep(0,n)
#' yerr2=rep(0,n)
#' biar=BiARkalman(series1=y1[1,],series2=y1[2,],times=st,series_esd1 = yerr1,series_esd2=yerr2)
#' biar
#' predbiar=BiARfit(coef=c(biar$phiR,biar$phiI),series1=y1[1,],series2=y1[2,],times=st,series_esd1 = 
#' rep(0,length(y[1,])),series_esd2=rep(0,length(y[1,])))
#' rho=predbiar$rho
#' print(rho)
#' yhat=predbiar$fitted
#' }
#' @noRd
BiARfit <- function(coef, series1, series2, times, series_esd1, series_esd2, zero_mean = TRUE) {
    .Call(`_iAR_BiARfit`, coef, series1, series2, times, series_esd1, series_esd2, zero_mean)
}

#' Forecast from BiAR model
#'
#' Forecast from models fitted by \code{\link{BiARkalman}}
#'
#' @param coef An array with the parameters of the BiAR model. The elements of the array are, in order, the autocorrelation and the cross-correlation coefficient of the BiAR model.
#' @param series1 Array with the observations of the first time series of the BiAR process.
#' @param series2 Array with the observations of the second time series of the BiAR process.
#' @param times Array with the observational times.
#' @param tAhead The time ahead for which the forecast is required.
#'
#' @return A list with the following components:
#' \itemize{
#' \item{forecast}{ Point forecast in the time ahead required.}
#' }
#' @references
#' \insertRef{Elorrieta_2021}{iAR}
#'
#' @seealso
#'
#' \code{\link{BiARsample}}, \code{\link{BiARkalman}}, \code{\link{BiARfit}}
#'
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' #Simulated Data
#' n=100
#' set.seed(6714)
#' st<-gentime(n)
#' x=BiARsample(phiR=0.9,phiI=0.3,times=st)
#' biar=iAR::BiARkalman(series1=x$series[1,],series2=x$series[2,],times=st)
#' forBiAR<-BiARforecast(coef=c(biar$phiR,biar$phiI),series1=x$series[1,],series2=x$series[2,],
#' times=st,tAhead=c(1.3))
#' }
#' @noRd
BiARforecast <- function(coef, series1, series2, times, tAhead) {
    .Call(`_iAR_BiARforecast`, coef, series1, series2, times, tAhead)
}

#' Minus Log Likelihood of the BiAR Model
#'
#' This function return the negative log likelihood of the BiAR process given specific values of phiR and phiI
#'
#'
#' @param coef An array with the parameters of the BiAR model. The elements of the array are, in order, the autocorrelation and the cross-correlation coefficient of the BiAR model.
#' @param series1 Array with the observations of the first time series of the BiAR process.
#' @param series2 Array with the observations of the second time series of the BiAR process.
#' @param times Array with the irregular observational times.
#' @param series_esd1 Array with the measurements error standard deviations of the first time series of the BiAR process.
#' @param series_esd2 Array with the measurements error standard deviations of the second time series of the BiAR process.
#' @param zero_mean logical; if TRUE, the array y has zero mean; if FALSE, y has a mean different from zero.
#' @param yest An array with the estimate of a missing value in one or both time series of the bivariate process. This function recognizes a missing value with a NA. If the bivariate time series does not have a missing value, this value does not affect the computation of the likelihood.
#'
#' @return Value of the negative log likelihood evaluated in phiR and phiI.
#'
#' @references
#' \insertRef{Elorrieta_2021}{iAR}
#' @seealso
#' \code{\link{gentime}}, \code{\link{BiARsample}}
#'
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=300
#' set.seed(6714)
#' st<-gentime(n)
#' x=BiARsample(phiR=0.9,phiI=0.3,times=st)
#' y=x$series
#' y1=y[1,]
#' y2=y[2,]
#' yerr1=rep(0,n)
#' yerr2=rep(0,n)
#' BiARphikalman(coef=c(0.8,0.2),series1=y1,series2=y2,times=st,
#' series_esd1=yerr1,series_esd2=yerr2,yest=c(0,0))
#' }
#' @noRd
BiARphikalman <- function(yest, coef, series1, series2, times, series_esd1, series_esd2, zero_mean = TRUE) {
    .Call(`_iAR_BiARphikalman`, yest, coef, series1, series2, times, series_esd1, series_esd2, zero_mean)
}

#' Fitted Values of CiAR model
#'
#' Fit a CiAR model to an irregularly observed time series.
#'
#' @param coef An array with the parameters of the CiAR model. The elements of the array are, in order, the real and the imaginary part of the phi parameter of the CiAR model.
#' @param series Array with the time series observations.
#' @param times Array with the irregular observational times.
#' @param standardized logical; if TRUE, the array series is standardized; if FALSE, series contains the raw time series
#' @param zero_mean logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.
#' @param c Nuisance parameter corresponding to the variance of the imaginary part.
#'
#' @return A list with the following components:
#' \item{fitted}{ Fitted values of the observable part of CiAR model.}
#' \item{xhat}{ Fitted values of both observable part and imaginary part of CiAR model.}
#' \item{Lambda}{ Lambda value estimated by the CiAR model at the last time point.}
#' \item{Theta}{ Theta array estimated by the CiAR model at the last time point.}
#' \item{Sighat}{ Covariance matrix estimated by the CiAR model at the last time point.}
#' \item{Qt}{ Covariance matrix of the state equation estimated by the CiAR model at the last time point.}
#' @references
#' \insertRef{Elorrieta_2019}{iAR}
#'
#' @examples
#' \dontshow{
#' n=100
#' set.seed(6714)
#' }
CiARfit <- function(coef, series, times, zero_mean = TRUE, standardized = TRUE, c = 1) {
    .Call(`_iAR_CiARfit`, coef, series, times, zero_mean, standardized, c)
}

#' Forecast from CiAR model
#'
#' Forecast from models fitted by \code{\link{CiARkalman}}
#'
#' @param coef An array with the parameters of the CiAR model. The elements of the array are, in order, the real and the imaginary part of the phi parameter of the CiAR model.
#' @param series Array with the time series observations.
#' @param times Array with the observational times.
#' @param tAhead The time ahead for which the forecast is required.
#' @param standardized logical; if TRUE, the array series is standardized; if FALSE, series contains the raw time series
#' @param zero_mean logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.
#'
#' @return A list with the following components:
#' \itemize{
#' \item{forecast}{ Point forecast in the time ahead required.}
#' }
#' @references
#' \insertRef{Elorrieta_2019}{iAR}
#'
#' @seealso
#'
#' \code{\link{CiARsample}}, \code{\link{CiARkalman}}, \code{\link{CiARfit}}
#'
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' #Simulated Data
#' n=100
#' set.seed(6714)
#' st<-gentime(n)
#' x=CiARsample(phiR=0.9,phiI=0,times=st,c=1)
#' y=x$series
#' y1=y/sd(y)
#' n=length(y1)
#' p=trunc(n*0.99)
#' ytr=y1[1:p]
#' yte=y1[(p+1):n]
#' str=st[1:p]
#' ste=st[(p+1):n]
#' tahead=ste-str[p]
#'
#' ciar=CiARkalman(series=ytr,times=str)
#' forCIAR<-CiARforecast(coef=c(ciar$phiR,ciar$phiI),series=ytr,times=str,tAhead=tahead)
#' }
#' @noRd
CiARforecast <- function(coef, series, times, tAhead, zero_mean = TRUE, standardized = TRUE) {
    .Call(`_iAR_CiARforecast`, coef, series, times, tAhead, zero_mean, standardized)
}

#' Minus Log Likelihood of the CiAR Model
#'
#' This function return the negative log likelihood of the CiAR process given specific values of phiR and phiI
#'
#' @param coef An array with the parameters of the CiAR model. The elements of the array are, in order, the real (phiR) and the imaginary (phiI) part of the coefficient of CiAR model.
#' @param series Array with the time series observations.
#' @param times Array with the irregular observational times.
#' @param series_esd Array with the measurements error standard deviations.
#' @param zero_mean logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.
#' @param standardized logical; if TRUE, the array series is standardized; if FALSE, series contains the raw time series.
#' @param c Nuisance parameter corresponding to the variance of the imaginary part.
#' @param yest The estimate of a missing value in the time series. This function recognizes a missing value with a NA. If the time series does not have a missing value, this value does not affect the computation of the likelihood.
#'
#' @return Value of the negative log likelihood evaluated in the coefficients phiR and phiI.
#' @references
#' \insertRef{Elorrieta_2019}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}, \code{\link{CiARsample}}
#'
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=300
#' set.seed(6714)
#' st<-gentime(n)
#' x=CiARsample(phiR=0.9,phiI=0,times=st,c=1)
#' y=x$series
#' yerr=rep(0,n)
#' CiARphikalman(coef=c(0.8,0),series=y,times=st,series_esd=yerr,yest=0)
#' }
#' @noRd
CiARphikalman <- function(yest, coef, series, times, series_esd, zero_mean = TRUE, standardized = TRUE, c = 1.0) {
    .Call(`_iAR_CiARphikalman`, yest, coef, series, times, series_esd, zero_mean, standardized, c)
}

#' Simulate from a CiAR Model
#'
#' Simulates a CiAR Time Series Model
#'
#' @param times Array with observational times.
#' @param phiR Real part of the coefficient of CiAR model. A value between -1 and 1.
#' @param phiI Imaginary part of the coefficient of CiAR model. A value between -1 and 1.
#' @param rho Correlation between the real and the imaginary part of the process. A value between -1 and 1.
#' @param c Nuisance parameter corresponding to the variance of the imaginary part.
#'
#' @details The chosen phiR and phiI values must satisfy the condition $|phiR + i phiI| < 1$.
#'
#' @return A list with the following components:
#' \itemize{
#' \item{series}{ Array with the simulated real part of the CiAR process.}
#' }
#' @references
#' \insertRef{Elorrieta_2019}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=300
#' set.seed(6714)
#' st<-gentime(n)
#' x=CiARsample(phiR=0.9,phiI=0,times=st,c=1)
#' plot(st,x$series,type='l')
#' x=CiARsample(phiR=-0.9,phiI=0,times=st,c=1)
#' plot(st,x$series,type='l')
#' }
#' @noRd
CiARsample <- function(phiR, phiI, times, rho = 0L, c = 1L) {
    .Call(`_iAR_CiARsample`, phiR, phiI, times, rho, c)
}

#' Simulate from an iAR-Gamma Model
#'
#' Simulates an iAR-Gamma Time Series Model.
#'
#' @param coef A coefficient of iAR-Gamma model. A value between 0 and 1.
#' @param times Array with observational times.
#' @param sigma Scale parameter of the IAR-Gamma process. A positive value.
#' @param mean Mean parameter of the IAR-Gamma process. A positive value.
#'
#' @return  A list with the following components:
#' \itemize{
#' \item{series}{ Array with simulated IAR-Gamma process.}
#' \item{times}{ Array with observation times.}
#' }
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=100
#' set.seed(6714)
#' st<-gentime(n)
#' y<-iARgsample(coef=0.9,times=st,sigma=1,mean=1)
#' plot(st,y$series,type='l')
#' hist(y$series,breaks=20)
#' }
#' @noRd
iARgsample <- function(coef, times, sigma = 1L, mean = 1L) {
    .Call(`_iAR_iARgsample`, coef, times, sigma, mean)
}

#' Minus Log Likelihood iAR-Gamma Model
#'
#' This function return the negative log likelihood of the iAR-Gamma given specific values of phi, mean and sigma.
#'
#' @param coef An array with the parameters of the iAR-Gamma model. The first element of the array corresponding to the phi parameter, the second to the mean parameter, and the last one to the scale parameter sigma.
#' @param series Array with the time series observations.
#' @param times Array with the irregular observational times.
#' @param yest The estimate of a missing value in the time series. This function recognizes a missing value with a NA. If the time series does not have a missing value, this value does not affect the computation of the likelihood.
#'
#' @return Value of the negative log likelihood evaluated in phi, mean and sigma.
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}, \code{\link{iARgsample}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=100
#' set.seed(6714)
#' st<-gentime(n)
#' y<-iARgsample(coef=0.9,times=st,sigma=1,mean=1)
#' iARphigamma(coef=c(0.9,1,1),series=y$series,times=st,yest=0)
#' }
#' @noRd
iARphigamma <- function(yest, coef, series, times) {
    .Call(`_iAR_iARphigamma`, yest, coef, series, times)
}

#' Minus Log Likelihood of the iAR Model estimated via Kalman Recursions
#'
#' This function return the negative log likelihood of the iAR process given a specific value of phi.
#'
#' @param coef A given phi coefficient of the iAR model.
#' @param series Array with the time series observations.
#' @param series_esd Array with the measurements error standard deviations.
#' @param times Array with the irregular observational times.
#' @param zero_mean logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.
#' @param standardized logical; if TRUE, the array series is standardized; if FALSE, series contains the raw time series.
#' @param yest The estimate of a missing value in the time series. This function recognizes a missing value with a NA. If the time series does not have a missing value, this value does not affect the computation of the likelihood.
#'
#' @return Value of the negative log likelihood evaluated in phi.
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}, \code{\link{iARsample}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' set.seed(6714)
#' st<-gentime(n=100)
#' y<-iARsample(coef=0.99,times=st)
#' y<-y$series
#' yerr=rep(0,100)
#' iARphikalman(coef=0.8,series=y,series_esd=yerr,times=st,yest=0)
#' }
#' @noRd
iARphikalman <- function(yest, coef, series, series_esd, times, zero_mean = TRUE, standardized = TRUE) {
    .Call(`_iAR_iARphikalman`, yest, coef, series, series_esd, times, zero_mean, standardized)
}

#' Minus Log Likelihood of the iAR Model
#'
#' This function return the negative log likelihood of the iAR Model for a specific value of phi.
#'
#' @param coef A given phi coefficient of the iAR model.
#' @param series Array with the time series observations.
#' @param times Array with the irregular observational times.
#' @param series_esd Array with the measurements error standard deviations.
#' @param zero_mean logical; if TRUE, the array series has zero mean; if FALSE, series has a mean different from zero.
#' @param standardized logical; if TRUE, the array series was standardized; if FALSE, series contains the raw data
#'
#' @return Value of the negative log likelihood evaluated in phi.
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}, \code{\link{iARsample}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' set.seed(6714)
#' st<-gentime(n=100)
#' y<-iARsample(coef=0.99,times=st)
#' y<-y$series
#' iARphiloglik(coef=0.8,series=y,times=st,series_esd=0)
#' }
#' @noRd
iARphiloglik <- function(coef, series, times, series_esd, zero_mean = TRUE, standardized = TRUE) {
    .Call(`_iAR_iARphiloglik`, coef, series, times, series_esd, zero_mean, standardized)
}

#' Minus Log Likelihood iAR-T Model
#'
#' This function return the negative log likelihood of the iAR-T given specific values of phi and sigma.
#'
#' @param coef An array with the parameters of the iAR-T model. The first element of the array corresponding to the phi parameter and the second element to the scale parameter sigma
#' @param series Array with the time series observations
#' @param times Array with the irregular observational times
#' @param df degrees of freedom
#' @param yest The estimate of a missing value in the time series. This function recognizes a missing value with a NA. If the time series does not have a missing value, this value does not affect the computation of the likelihood.
#'
#' @return Value of the negative log likelihood evaluated in phi,sigma and df.
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}, \code{\link{iARtsample}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' n=300
#' set.seed(6714)
#' st<-gentime(n)
#' y<-iARtsample(coef=0.9,times=st,sigma=1,df=3)
#' iARphit(coef=c(0.9,1),series=y$series,times=st,yest=0)
#' }
#' @noRd
iARphit <- function(yest, coef, series, times, df = 3) {
    .Call(`_iAR_iARphit`, yest, coef, series, times, df)
}

#' Simulate from an iAR Model
#'
#' Simulates an iAR Time Series Model.
#'
#' @param coef A coefficient of iAR model. A value between 0 and 1
#' @param times Array with observational times.
#'
#' @return A list with the following components:
#' \itemize{
#' \item{series}{ Array with simulated iAR data.}
#' }
#' @references
#' \insertRef{Eyheramendy_2018}{iAR}
#'
#' @seealso
#'
#' \code{\link{gentime}}
#'
#' @keywords internal
#' @examples
#' \dontshow{
#' set.seed(6714)
#' st<-gentime(n=100)
#' y<-iARsample(coef=0.99,times=st)
#' y<-y$series
#' plot(st,y,type='l')
#' }
#' @noRd
iARsample <- function(coef, times) {
    .Call(`_iAR_iARsample`, coef, times)
}

