% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tox.profile.R
\name{tox.profile}
\alias{tox.profile}
\title{Generates DLTs and calculate the likelihood-ratio (LR) for each dose}
\usage{
tox.profile(dose, dose.tox, p1, p2, K, coh.size)
}
\arguments{
\item{dose}{number of doses to be tested (scalar)}

\item{dose.tox}{vector of true toxicities for each dose. Values range from 0 - 1.}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}

\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}
}
\value{
4-column matrix containing dose assignment, dose-limiting toxicities at each dose, 
cohort number, and likelihood ratio.
}
\description{
Gives toxicity profile (number of dose-limiting toxicities) and likelihood ratio of safety for each dose.
}
\examples{
# Number of pre-specified dose levels
dose <- 5
# Vector of true toxicities associated with each dose
dose.tox <- c(0.05, 0.10, 0.20, 0.35, 0.45)       
# Acceptable (p2) and unacceptable (p1) DLT rates used for establishing safety
p1 <- 0.40                                     
p2 <- 0.15    

# Likelihood-ratio (LR) threshold
K <- 2                                          

# Cohort size used in stage 1
coh.size <- 3 

# Vector of true mean efficacies per dose (here mean percent persistence per dose)
m <- c(5, 15, 40, 65, 80)   # MUST BE THE SAME LENGTH AS dose.tox                  

# Efficacy(equal) variance per dose
v <- rep(0.01, 5) 

# Total sample size (stages 1&2)                            
N <- 25                                        

# Stopping rule: if dose 1 is the only safe dose, allocate up to 9 pts.
stop.rule <- 9 

tox.profile(dose = dose, dose.tox = dose.tox, p1 = p1, p2 = p2, K = K, coh.size = coh.size)


}
