% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F032.pseudotime.tree.R
\name{pseudotime.tree}
\alias{pseudotime.tree}
\title{Pseudotime Tree}
\usage{
pseudotime.tree(x = NULL, marker.genes = "NULL",
  clust.names = "NULL", dist.method = "euclidean",
  clust.method = "complete", label.offset = 0.5, type = "classic",
  hang = 1, cex = 1)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{marker.genes}{A list of marker genes for clusters.}

\item{clust.names}{A list of names for clusters.}

\item{dist.method}{Choose from "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski", default = "euclidean".}

\item{clust.method}{Choose from "ward.D", "ward.D2", "single", "complete", "average", "mcquitty", "median" or "centroid", default = "complete".}

\item{label.offset}{Space between names and tree, default = 0.5.}

\item{type}{Choose from "classic", "jitter", "unrooted", "fan", "cladogram", "radial", default = "classic".}

\item{hang}{Hang, default = 1.}

\item{cex}{Text size, default = 1.}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and marker genes for clusters and performs pseudotime for differentiation or time course analysis.
}
\examples{
marker.genes <- findMarkers(demo.obj,fold.change = 2,padjval = 0.1,uniq = TRUE)

MyGenes <- top.markers(marker.genes, topde = 10, min.base.mean = 0.8)

pseudotime.tree(demo.obj,
               marker.genes = MyGenes,
               type = "unrooted",
               clust.method = "complete")

}
