\name{Accuracy}
\alias{Accuracy}
\title{Accuracy measures for a forecast model}
\usage{
Accuracy(f,x)
}

\arguments{
\item{f}{A time series forecasting object generated by \code{iForecast}.}

\item{x}{Actual values of the same length as the time series object of \code{f}.}

}

\value{
Matrix giving forecast accuracy measures.
}

\description{
Returns range of summary measures of the forecast accuracy. Except MAAPE, all measures are defined and discussed in Hyndman
and Koehler (2006).
}

\details{
The measures calculated are:

\itemize{
  \item RMSE: Root Mean Squared Error
  \item MAE: Mean Absolute Error
  \item MAPE: Mean Absolute Percentage Error
  \item MAAPE: Mean Absolute Arctan Percentage Error
  \item ACF1: Autocorrelation of errors at lag 1.
}

Except MAAPE, by default, see Hyndman and Koehler (2006) and Hyndman and Athanasopoulos (2014, Section
2.5) for further details. For MAAPE, please see Kim and Kim (2016).
}

\references{
Hyndman, R.J. and Koehler, A.B. (2006) "Another look at measures of forecast accuracy". \emph{International Journal of Forecasting}, \bold{22}(4), 679-688.\cr
Hyndman, R.J. and Athanasopoulos, G. (2018) "Forecasting: principles and practice", 2nd ed., OTexts, Melbourne, Australia. Section 3.4 "Evaluating forecast accuracy".<https://otexts.com/fpp2/accuracy.html>\cr
Kim Sungil and Heeyoung Kim (2016) "A new metric of absolute percentage error for intermittent demand forecasts", \emph{International Journal of Forecasting},\bold{32}(3),669-679. <https://doi.org/10.1016/j.ijforecast.2015.12.003>.
}


\author{
Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.

}


\examples{

tmp0=timeSeries::as.timeSeries(ts(rnorm(800),start=c(1960,1),freq=12))
fit1 <- timeSeries::as.timeSeries(forecast::rwf(tmp0[1:700,1],h=100)$mean)
Accuracy(f=fit1,x=tmp0[701:800,1])
}
