/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import java.util.Formatter;
import java.util.Locale;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;

public class Axis {
    public static final boolean ORIENTATION_VERTICAL = false;
    public static final boolean ORIENTATION_HORIZONTAL = true;
    private NumberAxis axis;
    private boolean orientation;
    private double twinAxisPosition = 0.0;
    private boolean tick0Flag;
    private boolean labelsFlag;
    private String[] labelsName;
    private double[] labelsValue;

    private double fixStep(double minA, double maxA, double step) {
        double H = 10.0;
        double inter = maxA - minA;
        while (step > inter) {
            step /= 10.0;
        }
        while (step < inter / 10.0) {
            step *= 10.0;
        }
        if (step > inter / 2.0) {
            step /= 2.0;
        }
        return step;
    }

    public Axis(NumberAxis inAxis, boolean orientation) {
        this.axis = inAxis;
        this.orientation = orientation;
        this.labelsFlag = false;
        this.labelsValue = null;
        this.labelsName = null;
        inAxis.setAutoRangeIncludesZero(false);
        inAxis.setLowerMargin(0.0);
        inAxis.setUpperMargin(0.0);
        this.axis.setTickUnit(new NumberTickUnit(this.computeAutoTickValue()));
    }

    protected NumberAxis getAxis() {
        return this.axis;
    }

    public String getLabel() {
        return this.axis.getLabel();
    }

    public void setLabel(String label) {
        this.axis.setLabel(label);
    }

    public void setLabels(double tick) {
        this.axis.setTickUnit(new NumberTickUnit(tick));
        this.labelsFlag = false;
    }

    public void setLabelsAuto() {
        this.axis.setTickUnit(new NumberTickUnit(this.computeAutoTickValue()));
        this.labelsFlag = false;
    }

    @Deprecated
    public void enableCustomLabels() {
        this.labelsFlag = true;
    }

    @Deprecated
    public void disableCustomLabels() {
        this.labelsFlag = false;
    }

    public void setLabels(double[] position) {
        this.labelsName = null;
        this.labelsValue = (double[])position.clone();
        double max = Axis.max(position);
        if (this.axis.getUpperBound() < max) {
            this.axis.setUpperBound(max);
        }
        double min = Axis.min(position);
        if (this.axis.getLowerBound() > min) {
            this.axis.setLowerBound(min);
        }
        this.labelsFlag = true;
    }

    public void setLabels(double[] position, String[] label) {
        if (label.length != position.length) {
            throw new IllegalArgumentException("A label is required for each given position");
        }
        this.labelsName = (String[])label.clone();
        this.labelsValue = (double[])position.clone();
        double max = Axis.max(position);
        if (this.axis.getUpperBound() < max) {
            this.axis.setUpperBound(max);
        }
        double min = Axis.min(position);
        if (this.axis.getLowerBound() > min) {
            this.axis.setLowerBound(min);
        }
        this.labelsFlag = true;
    }

    public double getTwinAxisPosition() {
        return this.twinAxisPosition;
    }

    public void setTwinAxisPosition(double position) {
        this.twinAxisPosition = position;
    }

    public String toLatex(double scale) {
        Formatter formatter = new Formatter(Locale.US);
        double maxAxis = Math.max(this.axis.getRange().getUpperBound(), this.twinAxisPosition);
        double minAxis = Math.min(this.axis.getRange().getLowerBound(), this.twinAxisPosition);
        double pas = this.axis.getTickUnit().getSize();
        int puissDix = Math.log10(pas = this.fixStep(minAxis, maxAxis, pas)) < 0.0 ? (int)Math.log10(pas) - 1 : (int)Math.log10(pas);
        String arrowLeftType = "latex";
        String arrowRightType = "latex";
        String arrowLeftMargin = "3mm";
        String arrowRightMargin = "3mm";
        if (this.twinAxisPosition == minAxis) {
            arrowLeftType = "";
            arrowLeftMargin = "0mm";
        } else if (this.twinAxisPosition == maxAxis) {
            arrowRightType = "";
            arrowRightMargin = "0mm";
        }
        String label = this.axis.getLabel();
        if (label == null) {
            label = " ";
        }
        if (puissDix < -2 || puissDix > 2) {
            label = label + " $(10^{" + puissDix + "})$";
        } else {
            puissDix = 0;
        }
        if (this.orientation) {
            formatter.format("\\draw [%s-%s] ([xshift=-%s] %s,0) -- ([xshift=%s] %s,0) node[right] {%s};%n", arrowLeftType, arrowRightType, arrowLeftMargin, (minAxis - this.twinAxisPosition) * scale, arrowRightMargin, (maxAxis - this.twinAxisPosition) * scale, label);
            if (this.labelsFlag) {
                for (int i = 0; i < this.labelsValue.length; ++i) {
                    String name;
                    double value = this.labelsValue[i];
                    if (this.labelsName == null) {
                        double labelTemp = value * 100.0 / Math.pow(10.0, puissDix);
                        name = Integer.toString((int)(labelTemp / 100.0));
                    } else {
                        name = this.labelsName[i];
                    }
                    if (value == this.twinAxisPosition && this.tick0Flag) {
                        formatter.format("\\draw (%s,00) -- +(0mm,1mm) -- +(0mm,-1mm) node[below right] {%s};%n", (value - this.twinAxisPosition) * scale, name);
                        continue;
                    }
                    formatter.format("\\draw (%s,0) -- +(0mm,1mm) -- +(0mm,-1mm) node[below] {%s};%n", (value - this.twinAxisPosition) * scale, name);
                }
            } else {
                double k = this.twinAxisPosition;
                double labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                String precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                if (this.tick0Flag) {
                    formatter.format("\\draw (%s,0) -- +(0mm,1mm) -- +(0mm,-1mm) node[below right] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                } else {
                    formatter.format("\\draw (%s,0) -- +(0mm,1mm) -- +(0mm,-1mm) node[below] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                }
                k += pas;
                while (k <= maxAxis) {
                    labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                    precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                    formatter.format("\\draw (%s,0) -- +(0mm,1mm) -- +(0mm,-1mm) node[below] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                    k += pas;
                }
                for (k = this.twinAxisPosition - pas; k >= minAxis; k -= pas) {
                    labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                    precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                    formatter.format("\\draw (%s,0) -- +(0mm,1mm) -- +(0mm,-1mm) node[below] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                }
            }
        } else {
            formatter.format("\\draw [%s-%s] ([yshift=-%s] 0,%s) -- ([yshift=%s] 0, %s) node[above] {%s};%n", arrowLeftType, arrowRightType, arrowLeftMargin, (minAxis - this.twinAxisPosition) * scale, arrowRightMargin, (maxAxis - this.twinAxisPosition) * scale, label);
            if (this.labelsFlag) {
                for (int i = 0; i < this.labelsValue.length; ++i) {
                    double labelTemp;
                    double value = this.labelsValue[i];
                    String name = this.labelsName == null ? ((labelTemp = value * scale * 100.0 / Math.pow(10.0, puissDix)) == (double)((int)labelTemp) ? Integer.toString((int)(labelTemp / 100.0)) : Double.toString((double)Math.round(labelTemp) / 100.0)) : this.labelsName[i];
                    if (value == this.twinAxisPosition && this.tick0Flag) {
                        formatter.format("\\draw (%s,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[above left] {%s};%n", 0, (value - this.twinAxisPosition) * scale, name);
                        continue;
                    }
                    formatter.format("\\draw (%s,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[left] {%s};%n", 0, (value - this.twinAxisPosition) * scale, name);
                }
            } else {
                double k = this.twinAxisPosition;
                double labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                String precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                if (this.tick0Flag) {
                    formatter.format("\\draw (0,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[above left] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                } else {
                    formatter.format("\\draw (0,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[left] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                }
                k += pas;
                while (k <= maxAxis) {
                    labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                    precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                    formatter.format("\\draw (0,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[left] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                    k += pas;
                }
                for (k = this.twinAxisPosition - pas; k >= minAxis; k -= pas) {
                    labelTemp = (double)Math.round(k * 100.0 / Math.pow(10.0, puissDix)) / 100.0;
                    precisionAffichageLabel = labelTemp == (double)((int)labelTemp) ? "0" : (labelTemp * 10.0 == (double)((int)(labelTemp * 10.0)) ? "1" : "2");
                    formatter.format("\\draw (0,%s) -- +(1mm,0mm) -- +(-1mm,0mm) node[left] {%." + precisionAffichageLabel + "f};%n", (k - this.twinAxisPosition) * scale, labelTemp);
                }
            }
        }
        return formatter.toString();
    }

    private double computeAutoTickValue() {
        double pas;
        double[] bounds = new double[]{Math.min(this.axis.getRange().getLowerBound(), this.twinAxisPosition), Math.max(this.axis.getRange().getUpperBound(), this.twinAxisPosition)};
        if (bounds[1] - bounds[0] >= 1.0) {
            int nbMaxDeFois = (int)(bounds[1] - bounds[0]);
            int puissDix = (int)Math.log10(nbMaxDeFois);
            pas = (nbMaxDeFois = (int)((double)nbMaxDeFois / Math.pow(10.0, puissDix)) + 1) > 5 ? Math.pow(10.0, puissDix) : (nbMaxDeFois > 3 ? 0.5 * Math.pow(10.0, puissDix) : (nbMaxDeFois > 1 ? 0.25 * Math.pow(10.0, puissDix) : 0.1 * Math.pow(10.0, puissDix)));
        } else {
            double nbMaxDeFois = bounds[1] - bounds[0];
            int puissDix = 0;
            while (nbMaxDeFois < 1.0) {
                nbMaxDeFois *= 10.0;
                ++puissDix;
            }
            pas = nbMaxDeFois > 5.0 ? 1.0 / Math.pow(10.0, puissDix) : (nbMaxDeFois > 3.0 ? 0.5 / Math.pow(10.0, puissDix) : (nbMaxDeFois > 1.0 ? 0.3 / Math.pow(10.0, puissDix) : 0.1 / Math.pow(10.0, puissDix)));
        }
        return pas;
    }

    private static double max(double[] t) {
        if (t == null) {
            throw new IllegalArgumentException("max:   null argument.");
        }
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] > aux)) continue;
            aux = t[i];
        }
        return aux;
    }

    private static double min(double[] t) {
        if (t == null) {
            throw new IllegalArgumentException("min:   null argument.");
        }
        double aux = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (!(t[i] < aux)) continue;
            aux = t[i];
        }
        return aux;
    }

    void setTick0Flag(boolean flag) {
        this.tick0Flag = flag;
    }
}

