% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMRMC.R
\name{sim.gRoeMetz}
\alias{sim.gRoeMetz}
\title{Simulate an MRMC data set of an ROC experiment comparing two modalities}
\usage{
sim.gRoeMetz(config)
}
\arguments{
\item{config}{[list] of simulation parameters:
\itemize{
  \item Experiment labels and size
  \itemize{
    \item modalityID.A: [chr] label modality A
    \item modalityID.B: [chr] label modality B
    \item nR: [num] number of readers
    \item nC.neg: [num] number of signal-absent cases
    \item nC.pos: [num] number of signal-present cases
  }
  \item There are six fixed effects:
  \itemize{
    \item mu.neg: [num] signal-absent (neg, global mean)
    \item mu.pos: [num] signal-present (pos, global mean)
    \item mu.Aneg: [num] modality A signal-absent (Aneg, modality effect)
    \item mu.Bneg: [num] modality B signal-absent (Bneg, modality effect)
    \item mu.Apos: [num] modality A signal-present (Apos, modality effect)
    \item mu.Bpos: [num] modality B signal-present (Bpos, modality effect)
  }
  \item There are six random effects that are independent of modality
  \itemize{
    \item var_r.neg: [num] variance of random reader effect
    \item var_c.neg: [num] variance of random case effect
    \item var_rc.neg: [num] variance of random reader by case effect
    \item var_r.pos: [num] variance of random reader effect
    \item var_c.pos: [num] variance of random case effect
    \item var_rc.pos: [num] variance of random reader by case effect
  }
  \item There are six random effects that are specific to modality A
    \itemize{
      \item var_r.Aneg: [num] variance of random reader effect
      \item var_c.Aneg: [num] variance of random case effect
      \item var_rc.Aneg: [num] variance of random reader by case effect
      \item var_r.Apos: [num] variance of random reader effect
      \item var_c.Apos: [num] variance of random case effect
      \item var_rc.Apos: [num] variance of randome reader by case effect
  }
  \item There are six random effects that are specific to modality B
    \itemize{
      \item var_r.Bneg: [num] variance of random reader effect
      \item var_c.Bneg: [num] variance of random case effect
      \item var_rc.Bneg: [num] variance of random reader by case effect
      \item var_r.Bpos: [num] variance of random reader effect
      \item var_c.Bpos: [num] variance of random case effect
      \item var_rc.Bpos: [num] variance of randome reader by case effect
  }
}}
}
\value{
dFrame.imrmc   [data.frame] with (nC.neg + nC.pos)*(nR+1) rows including
\itemize{
  \item readerID: [Factor] w/ nR levels "reader1", "reader2", ...
  \item caseID: [Factor] w/ nC levels "case1", "case2", ...
  \item modalityID: [Factor] w/ 1 level config$modalityID
  \item score: [num] reader score
}

Note that the first nC.neg + nC.pos rows specify the truth labels for each case.
For these rows, the readerID must be "truth" or "-1"
and the score must be 0 for negative cases and 1 for postive cases.
}
\description{
This procedure simulates an MRMC data set of an ROC experiment comparing two modalities.
It is based on Gallas2014_J-Med-Img_v1p031006, which generalizes of the model in
Roe1997_Acad-Radiol_v4p298 and Roe1997_Acad-Radiol_v4p587. Specifically, it allows
the variance components to depend on the truth and the modality. For the simpler
Roe and Metz model, you can enter the smaller set of parameters into
sim.gRoeMetz.config and get back the larger set of parameters and then
used with this function.
}
\details{
The simulation is a linear model with six fixed effects related to
modality and truth and 18 normally distributed independent random effects
for readers, cases, and the interaction between the two. Here is the linear model:

L.mrct = mu.t + mu.mt \cr
       + reader.rt + case.ct + readerXcase.rct \cr
       + modalityXreader.mrt + modalityXcase.mct + modalityXreaderXcase.mrct \cr
\itemize{
  \item m=modality (levels: A and b)
  \item t=truth (levels: neg and Pos)
  \item mu.t is the global mean for t=neg and t=pos cases
  \item mu.mt is the modality specific fixed effects for t=neg and t=pos cases
  \item the remaining terms are the random effects: all independent normal random variables
}
}
\examples{
# Create a sample configuration object
config <- sim.gRoeMetz.config()
# Simulate an MRMC ROC data set
dFrame.imrmc <- sim.gRoeMetz(config)
# Analyze the MRMC ROC data
result <- doIMRMC(dFrame.imrmc)

}
