% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMRMC.R
\name{sim.gRoeMetz.config}
\alias{sim.gRoeMetz.config}
\title{Create a configuration object for the sim.gRoeMetz program}
\usage{
sim.gRoeMetz.config(nR = 5, nC.neg = 40, nC.pos = 40, mu.neg = 0,
  mu.pos = 1, var_r = 0.03, var_c = 0.3, var_rc = 0.2)
}
\arguments{
\item{nR}{Number of readers (default = 5)}

\item{nC.neg}{Number of signal-absent cases (default = 25)}

\item{nC.pos}{Number of signal-present cases (default = 25)}

\item{mu.neg}{Mean fixed effect of signal-absent distribution (default = 0.0) \cr
Modality specific parameters are set to zero: mu.Aneg = mu.Bneg = 0}

\item{mu.pos}{Mean fixed effect of signal-present distribution (default = 1.0) \cr
Modality specific parameters are set to zero: mu.Apos = mu.Bpos = 0}

\item{var_r}{Variance of reader random effect (default = 0.03) \cr
var_r.neg = var_r.pos = var_r.Aneg = var_r.Apos = var_r.Bneg = var_r.Bpos = var_r \cr}

\item{var_c}{Variance of case random effect (default = 0.30) \cr
var_c.neg = var_c.pos = var_c.Aneg = var_c.Apos = var_c.Bneg = var_c.Bpos = var_c \cr}

\item{var_rc}{Variance of reader.by.case random effect (default = 0.20) \cr
var_rc.neg = var_rc.pos = var_rc.Aneg = var_rc.Apos = var_rc.Bneg = var_rc.Bpos = var_rc \cr}
}
\value{
config [list] Refer to the sim.gRoeMetz input variable
}
\description{
This function creates a configuration object for the Roe & Metz
simulation model to be used as input for the sim.gRoeMetz program.
The default model returned when there are no arguments given to the function is
the "HH" model from Roe1987_Acad-Radiol_v4p298. Following that paper,
The user can specify three parameters related to experiment size (nR, nC.neg, nC.pos)
and five parameters parameters specifying a linear model that does not
depend on modality or truth (mu.neg, mu.pos, var_r, var_c, var_rc).
}
\details{
If no arguments, this function returns a default simulation
configuration for sim.gRoeMetz
}
\examples{
# Create a sample configuration object
config <- sim.gRoeMetz.config()
# Simulate an MRMC ROC data set
dFrame.imrmc <- sim.gRoeMetz(config)
# Analyze the MRMC ROC data
result <- doIMRMC(dFrame.imrmc)
}
