% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convertDF}
\alias{convertDF}
\title{Convert MRMC data frames}
\usage{
convertDF(inDF, inDFtype, outDFtype, readers)
}
\arguments{
\item{inDF}{An MRMC dataframe with reading study results in \code{inDFtype} format}

\item{inDFtype}{A string indicating the format type of the input MRMC data frame}

\item{outDFtype}{A string indicating the format type of the output MRMC data frame.}

\item{readers}{A character array holding the column names (readerIDs) corresponding to the data from different readers}
}
\value{
An MRMC dataframe with reading study results in \code{outDFtype} format
}
\description{
Convert MRMC data frames
}
\details{
MRMC data frames contain scores from readers, cases, and sometimes modalities. This packages deals with (currently)
two MRMC data frame formats. These are the formats:
\describe{
  \item{matrixMode}{
    For this format, each row contains all the information for a case, 
    including the reader study result for several readers, ground truth and other information as separate columns.
    This mode can only hold data from one modality.
  }
  \item{listMode}{
    For this format, each row contains the data for one observation. The columns 
    specify the readerID, caseID, score, ground truth, and other information if there is any.
    This mode can hold data from multiple modalities.
  }
}
}
