/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.randvar.InverseGaussianMSHGen;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.InverseGaussianProcess;

public class InverseGaussianProcessMSH
extends InverseGaussianProcess {
    protected RandomStream otherStream;
    protected NormalGen normalGen;

    public InverseGaussianProcessMSH(double s0, double delta, double gamma, RandomStream stream, RandomStream otherStream) {
        this.x0 = s0;
        this.setParams(delta, gamma);
        this.stream = stream;
        this.otherStream = otherStream;
        this.normalGen = new NormalGen(stream);
        this.numberOfRandomStreams = 2;
    }

    public double[] generatePath() {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += InverseGaussianMSHGen.nextDouble(this.otherStream, this.normalGen, this.imu[i], this.ilam[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] unifNorm, double[] unifOther) {
        double s = this.x0;
        NonRandomStream nonRandOther = new NonRandomStream(unifOther);
        this.normalGen.setStream(new NonRandomStream(unifNorm));
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += InverseGaussianMSHGen.nextDouble(nonRandOther, this.normalGen, this.imu[i], this.ilam[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        this.normalGen.setStream(this.stream);
        return this.path;
    }

    public double[] generatePath(double[] uniforms01) {
        throw new UnsupportedOperationException("Use generatePath with 2 streams");
    }

    public double nextObservation() {
        double s = this.path[this.observationIndex];
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.path[this.observationIndex] = s += InverseGaussianMSHGen.nextDouble(this.otherStream, this.normalGen, this.imu[this.observationIndex], this.ilam[this.observationIndex]);
        return s;
    }

    public RandomStream getStream() {
        if (this.stream != this.otherStream) {
            throw new IllegalStateException("Two different streams or more are present");
        }
        return this.stream;
    }

    public void setStream(RandomStream stream, RandomStream otherStream) {
        super.setStream(stream);
        this.normalGen.setStream(stream);
        this.setOtherStream(otherStream);
    }

    public void setStream(RandomStream stream) {
        super.setStream(stream);
        this.normalGen.setStream(stream);
        this.setOtherStream(stream);
    }

    public void setOtherStream(RandomStream otherStream) {
        this.otherStream = otherStream;
    }

    public RandomStream getOtherStream() {
        return this.otherStream;
    }

    public void setNormalGen(NormalGen normalGen) {
        this.normalGen = normalGen;
        this.stream = normalGen.getStream();
    }

    public NormalGen getNormalGen() {
        return this.normalGen;
    }

    protected class NonRandomStream
    implements RandomStream {
        double[] array;
        int position;

        public NonRandomStream(double[] array) {
            this.array = array;
            this.position = 0;
        }

        public NonRandomStream(double value) {
            this.array = new double[]{value};
            this.position = 0;
        }

        public double nextDouble() {
            return this.array[this.position++];
        }

        public void nextArrayOfDouble(double[] u, int start, int n) {
            for (int i = 0; i < n; ++i) {
                u[start + i] = this.array[this.position++];
            }
        }

        public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
            double diff = j - i;
            for (int ii = 0; ii < n; ++ii) {
                u[start + ii] = i + (int)Math.round(diff * this.array[this.position++]);
            }
        }

        public int nextInt(int i, int j) {
            return (int)Math.round((double)(j - i) * this.array[this.position]);
        }

        public void resetNextSubstream() {
        }

        public void resetStartStream() {
            this.position = 0;
        }

        public void resetStartSubstream() {
        }

        public String toString() {
            return new String("NonRandomStream of length " + this.array.length);
        }
    }
}

