/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.AndersonDarlingDist;
import umontreal.iro.lecuyer.util.RootFinder;

public class AndersonDarlingDistQuick
extends AndersonDarlingDist {
    private static double[] F2AD = new double[103];
    private static double[] CoAD = new double[103];

    private static double lower_Marsaglia(int n, double x) {
        double p0 = 2.00012 + (0.247105 - (0.0649821 - (0.0347962 - (0.011672 - 0.00168691 * x) * x) * x) * x) * x;
        return (p0 *= Math.exp(-1.2337141 / x) / Math.sqrt(x)) >= 0.0 ? p0 : 0.0;
    }

    private static double diffcdf(int n, double x, double EPS) {
        return (AndersonDarlingDistQuick.cdf(n, x + EPS) - AndersonDarlingDistQuick.cdf(n, x - EPS)) / (2.0 * EPS);
    }

    public AndersonDarlingDistQuick(int n) {
        super(n);
    }

    public double density(double x) {
        return AndersonDarlingDistQuick.density(this.n, x);
    }

    public double cdf(double x) {
        return AndersonDarlingDistQuick.cdf(this.n, x);
    }

    public double barF(double x) {
        return AndersonDarlingDistQuick.barF(this.n, x);
    }

    public double inverseF(double u) {
        return AndersonDarlingDistQuick.inverseF(this.n, u);
    }

    public static double density(int n, double x) {
        double D2;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return AndersonDarlingDistQuick.density_N_1(x);
        }
        if (x >= 100.0 || x <= 0.0) {
            return 0.0;
        }
        double EPS = 0.015625;
        double D1 = AndersonDarlingDistQuick.diffcdf(n, x, 0.015625);
        double res = D1 + (D1 - (D2 = AndersonDarlingDistQuick.diffcdf(n, x, 0.03125))) / 3.0;
        return res >= 0.0 ? res : 0.0;
    }

    public static double cdf(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("   n <= 0");
        }
        if (1 == n) {
            return AndersonDarlingDistQuick.cdf_N_1(x);
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 100.0) {
            return 1.0;
        }
        if (x <= 0.2) {
            return AndersonDarlingDistQuick.lower_Marsaglia(n, x);
        }
        return 1.0 - AndersonDarlingDistQuick.barF(n, x);
    }

    public static double barF(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            return AndersonDarlingDistQuick.barF_N_1(x);
        }
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= 1000.0) {
            return 0.0;
        }
        if (x > 5.0) {
            double nd = n;
            double q = (0.23945 * Math.pow(nd, -0.9379) - 0.1201 * Math.pow(nd, -0.96) - 1.0002816) * x - 1.437 * Math.pow(nd, -0.9379) + 1.441 * Math.pow(nd, -0.96) - 0.0633101;
            return Math.pow(x, -0.48897) * Math.exp(q);
        }
        if (x <= 0.2) {
            return 1.0 - AndersonDarlingDistQuick.cdf(n, x);
        }
        double H = 0.05;
        int i = (int)(1.0 + x / 0.05);
        double q = x / 0.05 - (double)i;
        double res = (F2AD[i - 2] - 2.0 * F2AD[i - 1] + F2AD[i]) * q * (q + 1.0) / 2.0 + (F2AD[i] - F2AD[i - 1]) * q + F2AD[i];
        res += (CoAD[i] * (q + 1.0) - CoAD[i - 1] * q) / (double)n;
        if ((res = 1.0 - res) >= 1.0) {
            return 1.0;
        }
        if (res <= 0.0) {
            return 0.0;
        }
        return res;
    }

    public static double inverseF(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (n == 1) {
            return AndersonDarlingDistQuick.inverse_N_1(u);
        }
        if (u == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u == 0.0) {
            return 0.0;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 50.0, f, 1.0E-5);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    static {
        AndersonDarlingDistQuick.F2AD[0] = 0.0;
        AndersonDarlingDistQuick.F2AD[1] = 1.7315E-10;
        AndersonDarlingDistQuick.F2AD[2] = 2.80781E-5;
        AndersonDarlingDistQuick.F2AD[3] = 0.00140856;
        AndersonDarlingDistQuick.F2AD[4] = 0.00958772;
        AndersonDarlingDistQuick.F2AD[5] = 0.02960552;
        AndersonDarlingDistQuick.F2AD[6] = 0.06185146;
        AndersonDarlingDistQuick.F2AD[7] = 0.10357152;
        AndersonDarlingDistQuick.F2AD[8] = 0.15127241;
        AndersonDarlingDistQuick.F2AD[9] = 0.20190317;
        AndersonDarlingDistQuick.F2AD[10] = 0.25318023;
        AndersonDarlingDistQuick.F2AD[11] = 0.30354278;
        AndersonDarlingDistQuick.F2AD[12] = 0.35200015;
        AndersonDarlingDistQuick.F2AD[13] = 0.39797537;
        AndersonDarlingDistQuick.F2AD[14] = 0.44117692;
        AndersonDarlingDistQuick.F2AD[15] = 0.48150305;
        AndersonDarlingDistQuick.F2AD[16] = 0.51897375;
        AndersonDarlingDistQuick.F2AD[17] = 0.55368396;
        AndersonDarlingDistQuick.F2AD[18] = 0.58577199;
        AndersonDarlingDistQuick.F2AD[19] = 0.61539864;
        AndersonDarlingDistQuick.F2AD[20] = 0.64273362;
        AndersonDarlingDistQuick.F2AD[21] = 0.66794694;
        AndersonDarlingDistQuick.F2AD[22] = 0.69120359;
        AndersonDarlingDistQuick.F2AD[23] = 0.7126605;
        AndersonDarlingDistQuick.F2AD[24] = 0.73246483;
        AndersonDarlingDistQuick.F2AD[25] = 0.7507533;
        AndersonDarlingDistQuick.F2AD[26] = 0.76765207;
        AndersonDarlingDistQuick.F2AD[27] = 0.78327703;
        AndersonDarlingDistQuick.F2AD[28] = 0.79773426;
        AndersonDarlingDistQuick.F2AD[29] = 0.81112067;
        AndersonDarlingDistQuick.F2AD[30] = 0.82352466;
        AndersonDarlingDistQuick.F2AD[31] = 0.83502676;
        AndersonDarlingDistQuick.F2AD[32] = 0.84570037;
        AndersonDarlingDistQuick.F2AD[33] = 0.85561231;
        AndersonDarlingDistQuick.F2AD[34] = 0.86482346;
        AndersonDarlingDistQuick.F2AD[35] = 0.87338931;
        AndersonDarlingDistQuick.F2AD[36] = 0.88136046;
        AndersonDarlingDistQuick.F2AD[37] = 0.88878306;
        AndersonDarlingDistQuick.F2AD[38] = 0.89569925;
        AndersonDarlingDistQuick.F2AD[39] = 0.90214757;
        AndersonDarlingDistQuick.F2AD[40] = 0.9081653;
        AndersonDarlingDistQuick.F2AD[41] = 0.91378043;
        AndersonDarlingDistQuick.F2AD[42] = 0.91902284;
        AndersonDarlingDistQuick.F2AD[43] = 0.92392345;
        AndersonDarlingDistQuick.F2AD[44] = 0.92850516;
        AndersonDarlingDistQuick.F2AD[45] = 0.93279084;
        AndersonDarlingDistQuick.F2AD[46] = 0.93680149;
        AndersonDarlingDistQuick.F2AD[47] = 0.94055647;
        AndersonDarlingDistQuick.F2AD[48] = 0.9440736;
        AndersonDarlingDistQuick.F2AD[49] = 0.94736933;
        AndersonDarlingDistQuick.F2AD[50] = 0.95045883;
        AndersonDarlingDistQuick.F2AD[51] = 0.95335611;
        AndersonDarlingDistQuick.F2AD[52] = 0.95607414;
        AndersonDarlingDistQuick.F2AD[53] = 0.9586249;
        AndersonDarlingDistQuick.F2AD[54] = 0.96101951;
        AndersonDarlingDistQuick.F2AD[55] = 0.96326825;
        AndersonDarlingDistQuick.F2AD[56] = 0.96538067;
        AndersonDarlingDistQuick.F2AD[57] = 0.96736563;
        AndersonDarlingDistQuick.F2AD[58] = 0.96923135;
        AndersonDarlingDistQuick.F2AD[59] = 0.97098548;
        AndersonDarlingDistQuick.F2AD[60] = 0.97263514;
        AndersonDarlingDistQuick.F2AD[61] = 0.97418694;
        AndersonDarlingDistQuick.F2AD[62] = 0.97564704;
        AndersonDarlingDistQuick.F2AD[63] = 0.97702119;
        AndersonDarlingDistQuick.F2AD[64] = 0.97831473;
        AndersonDarlingDistQuick.F2AD[65] = 0.97953267;
        AndersonDarlingDistQuick.F2AD[66] = 0.98067966;
        AndersonDarlingDistQuick.F2AD[67] = 0.98176005;
        AndersonDarlingDistQuick.F2AD[68] = 0.9827779;
        AndersonDarlingDistQuick.F2AD[69] = 0.98373702;
        AndersonDarlingDistQuick.F2AD[70] = 0.98464096;
        AndersonDarlingDistQuick.F2AD[71] = 0.98549304;
        AndersonDarlingDistQuick.F2AD[72] = 0.98629637;
        AndersonDarlingDistQuick.F2AD[73] = 0.98705386;
        AndersonDarlingDistQuick.F2AD[74] = 0.98776824;
        AndersonDarlingDistQuick.F2AD[75] = 0.98844206;
        AndersonDarlingDistQuick.F2AD[76] = 0.98907773;
        AndersonDarlingDistQuick.F2AD[77] = 0.98967747;
        AndersonDarlingDistQuick.F2AD[78] = 0.99024341;
        AndersonDarlingDistQuick.F2AD[79] = 0.99077752;
        AndersonDarlingDistQuick.F2AD[80] = 0.99128164;
        AndersonDarlingDistQuick.F2AD[81] = 0.99175753;
        AndersonDarlingDistQuick.F2AD[82] = 0.99220682;
        AndersonDarlingDistQuick.F2AD[83] = 0.99263105;
        AndersonDarlingDistQuick.F2AD[84] = 0.99303165;
        AndersonDarlingDistQuick.F2AD[85] = 0.99340998;
        AndersonDarlingDistQuick.F2AD[86] = 0.99376733;
        AndersonDarlingDistQuick.F2AD[87] = 0.99410488;
        AndersonDarlingDistQuick.F2AD[88] = 0.99442377;
        AndersonDarlingDistQuick.F2AD[89] = 0.99472506;
        AndersonDarlingDistQuick.F2AD[90] = 0.99500974;
        AndersonDarlingDistQuick.F2AD[91] = 0.99527876;
        AndersonDarlingDistQuick.F2AD[92] = 0.995533;
        AndersonDarlingDistQuick.F2AD[93] = 0.99577329;
        AndersonDarlingDistQuick.F2AD[94] = 0.99600042;
        AndersonDarlingDistQuick.F2AD[95] = 0.99621513;
        AndersonDarlingDistQuick.F2AD[96] = 0.9964181;
        AndersonDarlingDistQuick.F2AD[97] = 0.99661;
        AndersonDarlingDistQuick.F2AD[98] = 0.99679145;
        AndersonDarlingDistQuick.F2AD[99] = 0.99696303;
        AndersonDarlingDistQuick.F2AD[100] = 0.99712528;
        AndersonDarlingDistQuick.F2AD[101] = 0.99727872;
        AndersonDarlingDistQuick.F2AD[102] = 0.99742384;
        AndersonDarlingDistQuick.CoAD[0] = 0.0;
        AndersonDarlingDistQuick.CoAD[1] = 0.0;
        AndersonDarlingDistQuick.CoAD[2] = 0.0;
        AndersonDarlingDistQuick.CoAD[3] = 0.0;
        AndersonDarlingDistQuick.CoAD[4] = 0.0;
        AndersonDarlingDistQuick.CoAD[5] = -0.00187;
        AndersonDarlingDistQuick.CoAD[6] = 0.00898;
        AndersonDarlingDistQuick.CoAD[7] = 0.0209;
        AndersonDarlingDistQuick.CoAD[8] = 0.03087;
        AndersonDarlingDistQuick.CoAD[9] = 0.0377;
        AndersonDarlingDistQuick.CoAD[10] = 0.0414;
        AndersonDarlingDistQuick.CoAD[11] = 0.04386;
        AndersonDarlingDistQuick.CoAD[12] = 0.043;
        AndersonDarlingDistQuick.CoAD[13] = 0.0419;
        AndersonDarlingDistQuick.CoAD[14] = 0.0403;
        AndersonDarlingDistQuick.CoAD[15] = 0.038;
        AndersonDarlingDistQuick.CoAD[16] = 0.0354804;
        AndersonDarlingDistQuick.CoAD[17] = 0.032;
        AndersonDarlingDistQuick.CoAD[18] = 0.0293;
        AndersonDarlingDistQuick.CoAD[19] = 0.0261949;
        AndersonDarlingDistQuick.CoAD[20] = 0.0228;
        AndersonDarlingDistQuick.CoAD[21] = 0.0192;
        AndersonDarlingDistQuick.CoAD[22] = 0.0159865;
        AndersonDarlingDistQuick.CoAD[23] = 0.0129;
        AndersonDarlingDistQuick.CoAD[24] = 0.0107;
        AndersonDarlingDistQuick.CoAD[25] = 0.0082464;
        AndersonDarlingDistQuick.CoAD[26] = 0.00611;
        AndersonDarlingDistQuick.CoAD[27] = 0.00363;
        AndersonDarlingDistQuick.CoAD[28] = 0.00132272;
        AndersonDarlingDistQuick.CoAD[29] = -5.87E-4;
        AndersonDarlingDistQuick.CoAD[30] = -0.00275;
        AndersonDarlingDistQuick.CoAD[31] = -0.00395248;
        AndersonDarlingDistQuick.CoAD[32] = -0.00534;
        AndersonDarlingDistQuick.CoAD[33] = -0.006892;
        AndersonDarlingDistQuick.CoAD[34] = -0.00810208;
        AndersonDarlingDistQuick.CoAD[35] = -0.00893;
        AndersonDarlingDistQuick.CoAD[36] = -0.009552;
        AndersonDarlingDistQuick.CoAD[37] = -0.0104605;
        AndersonDarlingDistQuick.CoAD[38] = -0.0112;
        AndersonDarlingDistQuick.CoAD[39] = -0.01175;
        AndersonDarlingDistQuick.CoAD[40] = -0.0120216;
        AndersonDarlingDistQuick.CoAD[41] = -0.0124;
        AndersonDarlingDistQuick.CoAD[42] = -0.01253;
        AndersonDarlingDistQuick.CoAD[43] = -0.0127076;
        AndersonDarlingDistQuick.CoAD[44] = -0.0129;
        AndersonDarlingDistQuick.CoAD[45] = -0.01267;
        AndersonDarlingDistQuick.CoAD[46] = -0.0122015;
        AndersonDarlingDistQuick.CoAD[47] = -0.0122;
        AndersonDarlingDistQuick.CoAD[48] = -0.01186;
        AndersonDarlingDistQuick.CoAD[49] = -0.0117218;
        AndersonDarlingDistQuick.CoAD[50] = -0.0114;
        AndersonDarlingDistQuick.CoAD[51] = -0.01113;
        AndersonDarlingDistQuick.CoAD[52] = -0.0108459;
        AndersonDarlingDistQuick.CoAD[53] = -0.0104;
        AndersonDarlingDistQuick.CoAD[54] = -0.00993;
        AndersonDarlingDistQuick.CoAD[55] = -0.0095252;
        AndersonDarlingDistQuick.CoAD[56] = -0.00924;
        AndersonDarlingDistQuick.CoAD[57] = -0.00916;
        AndersonDarlingDistQuick.CoAD[58] = -0.0088004;
        AndersonDarlingDistQuick.CoAD[59] = -0.00863;
        AndersonDarlingDistQuick.CoAD[60] = -0.008336;
        AndersonDarlingDistQuick.CoAD[61] = -0.00810512;
        AndersonDarlingDistQuick.CoAD[62] = -0.00794;
        AndersonDarlingDistQuick.CoAD[63] = -0.00771;
        AndersonDarlingDistQuick.CoAD[64] = -0.00755064;
        AndersonDarlingDistQuick.CoAD[65] = -0.00725;
        AndersonDarlingDistQuick.CoAD[66] = -0.00711;
        AndersonDarlingDistQuick.CoAD[67] = -0.006834;
        AndersonDarlingDistQuick.CoAD[68] = -0.0065;
        AndersonDarlingDistQuick.CoAD[69] = -0.00628;
        AndersonDarlingDistQuick.CoAD[70] = -0.00611008;
        AndersonDarlingDistQuick.CoAD[71] = -0.00586;
        AndersonDarlingDistQuick.CoAD[72] = -0.005673;
        AndersonDarlingDistQuick.CoAD[73] = -0.00535008;
        AndersonDarlingDistQuick.CoAD[74] = -0.00511;
        AndersonDarlingDistQuick.CoAD[75] = -0.004786;
        AndersonDarlingDistQuick.CoAD[76] = -0.00459144;
        AndersonDarlingDistQuick.CoAD[77] = -0.00438;
        AndersonDarlingDistQuick.CoAD[78] = -0.00415;
        AndersonDarlingDistQuick.CoAD[79] = -0.00407696;
        AndersonDarlingDistQuick.CoAD[80] = -0.00393;
        AndersonDarlingDistQuick.CoAD[81] = -0.00383;
        AndersonDarlingDistQuick.CoAD[82] = -0.00374656;
        AndersonDarlingDistQuick.CoAD[83] = -0.00349;
        AndersonDarlingDistQuick.CoAD[84] = -0.00333;
        AndersonDarlingDistQuick.CoAD[85] = -0.00320064;
        AndersonDarlingDistQuick.CoAD[86] = -0.00309;
        AndersonDarlingDistQuick.CoAD[87] = -0.00293;
        AndersonDarlingDistQuick.CoAD[88] = -0.00278136;
        AndersonDarlingDistQuick.CoAD[89] = -0.00272;
        AndersonDarlingDistQuick.CoAD[90] = -0.00266;
        AndersonDarlingDistQuick.CoAD[91] = -0.00256208;
        AndersonDarlingDistQuick.CoAD[92] = -0.00243;
        AndersonDarlingDistQuick.CoAD[93] = -0.00228;
        AndersonDarlingDistQuick.CoAD[94] = -0.00213536;
        AndersonDarlingDistQuick.CoAD[95] = -0.002083;
        AndersonDarlingDistQuick.CoAD[96] = -0.00194;
        AndersonDarlingDistQuick.CoAD[97] = -0.00182;
        AndersonDarlingDistQuick.CoAD[98] = -0.00177;
        AndersonDarlingDistQuick.CoAD[99] = -0.00172;
        AndersonDarlingDistQuick.CoAD[100] = -0.00171104;
        AndersonDarlingDistQuick.CoAD[101] = -0.001741;
        AndersonDarlingDistQuick.CoAD[102] = -0.0016;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - AndersonDarlingDistQuick.cdf(this.n, x);
        }
    }
}

