% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doAUCMRMC.R
\name{doAUCmrmc}
\alias{doAUCmrmc}
\title{MRMC analysis for arbitrary design dataset}
\usage{
doAUCmrmc(data, flagROC = FALSE)
}
\arguments{
\item{data}{an iMRMC formatted data frame, see \link{dfMRMC_example}}

\item{flagROC}{boolean indicating if ROC results should be computed.}
}
\value{
The MRMC analysis results as a list, below is a quick summary:
\itemize{
  \item {\code{summaryMRMC, list}
   a list of summary study design information.
    \itemize{
      \item {\code{nM, num} number of modalities}
      \item {\code{nR, num} number of readers}
      \item {\code{nC.neg, num} number of signal-present caeses}
      \item {\code{nC.pos, num} number of signal-absent cases}
      \item {\code{modalites, char} names of modalities}
      \item {\code{readers, char} names of modalities}
      \item {\code{cases.neg, char} names of modalities}
      \item {\code{cases.pos, char} names of modalities}
    }
  }
  \item {\code{perReader.full, data.frame}
   this data frame contains the performance results for each reader and modality comparison.
             The analysis returns the final AUC results and the moments, coefficients of those moments. 
             Key variables of this data frame are AUC.1 (where '.1' indicates the row's reader and 
             modality '.1' pair), AUC.2 ('.2' indicates the '.2' reader and modality pair), and covAUC.}
  \item {\code{Ustat.full, data.frame}
   this data frame contains the reader-average AUC performance results.
             The analysis results are based on U-statistics.
             Key variables of this data frame are AUC.1, AUC.2, AUC1minusAUC2 and the corresponding
             variances, confidence intervals, degrees of freedom and p-values.}
  \item {\code{ROC, list}
   each object of this list is an object containing an ROC curve.
             There is an ROC curve for every combination of reader and modality.
             For every modality, there are also four average ROC curves. These are discussed in
               Chen2014_Br-J-Radiol_v87p20140016.
               The diagonal average averages the reader-specific ROC curves along y = -x + b for b in (0,1).
               The horizontal average averages the reader specific ROC curves along y = b for b in (0,1).
               The vertical average averages the reader specific ROC curves along x = b for b in (0,1).
               The pooled average ignores readerID and pools all the scores together to create one ROC curve.
  }
}
}
\description{
Execute a Multi-Reader, Multi-Case (MRMC) analysis
of ROC data from imaging studies where clinicians (readers) evaluate patient
images (cases). An overview of this software, including references presenting
details on the methods, can be found \href{https://zenodo.org/record/8383591}{HERE}
or as an entry in the FDA/CDRH Regulatory Science Tool Catalog
\href{https://www.fda.gov/medical-devices/science-and-research-medical-devices/imrmc-software-do-multi-reader-multi-case-statistical-analysis-reader-studies}{HERE}.
}
\examples{
# Create a sample configuration file
config <- sim.gRoeMetz.config()
# Simulate an MRMC ROC data set
dFrame.imrmc <- sim.gRoeMetz(config)
# Analyze the MRMC ROC data and compute ROC curves
aucResult <- doAUCmrmc(dFrame.imrmc, flagROC = TRUE)


}
