% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inzplot.R, R/inzplot_glm.R, R/inzplot_lm.R
\name{inzplot}
\alias{inzplot}
\alias{inzplot.glm}
\alias{inzplot.lm}
\title{inzplot method}
\usage{
\method{inzplot}{glm}(x, ..., env = parent.frame())

\method{inzplot}{lm}(
  x,
  which = c("residual", "scale", "leverage", "cooks", "normal", "hist"),
  show.bootstraps = nrow(x$model) < 1e+05,
  label.id = 3L,
  col.smooth = "orangered",
  col.bs = "lightgreen",
  cook.levels = c(0.5, 1),
  col.cook = "pink",
  ...,
  bs.fits = NULL,
  env = parent.frame()
)
}
\arguments{
\item{x}{a regression model}

\item{...}{additional arguments}

\item{env}{the environment for evaluating things (e.g., bootstraps)}

\item{which}{the type of plot to draw}

\item{show.bootstraps}{logical, if \code{TRUE} bootstrap smoothers will be shown (defaults to \code{TRUE} if fewer than 100,000 observations)}

\item{label.id}{integer for the number of extreme points to label (with row id)}

\item{col.smooth}{the colour of smoothers}

\item{col.bs}{the colour of bootstrap (smoothers)}

\item{cook.levels}{levels of the Cook's distance at which to draw contours.}

\item{col.cook}{the colour of Cook's distance contours}

\item{bs.fits}{a list of bootstrapped datasets}
}
\value{
A ggplot object with a plot method that will show the plot in the graphics device
}
\description{
inzplot method

Diagnostic Plots for Regression Models
}
\section{Functions}{
\itemize{
\item \code{inzplot.glm}: Method for GLMs
}}

\section{Plot types}{

There are several plot types available:
\itemize{
\item residual versus fitted
\item scale-location
\item residual versus leverage
\item Cook's distance
\item normal Q-Q
\item histogram array
}
}

\examples{
iris_fit <- lm(Sepal.Width ~ Sepal.Length, data = iris)
inzplot(iris_fit)
inzplot(iris_fit, which = "residual", show.bootstraps = FALSE)
}
\author{
Tom Elliott
}
