% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_cat_var.R
\name{combineCatVars}
\alias{combineCatVars}
\title{Combine categorical variables into one}
\usage{
combineCatVars(.data, vars, sep = ".", name = paste(vars, collapse = sep))
}
\arguments{
\item{.data}{a dataframe with the columns to be combined}

\item{vars}{a character vector of the categorical variables to be combined}

\item{sep}{the separator to combine the values of the variables
in \code{var} by. "." by default}

\item{name}{a name for the new variable}
}
\value{
original dataframe containing a new column of the renamed
        categorical variable with tidyverse code attached
}
\description{
Combine specified categorical variables by concatenating
their values into one character, and returns the result
along with tidyverse code used to generate it.
}
\examples{
combined <- combineCatVars(warpbreaks, vars = c("wool", "tension"), sep = "_")
cat(code(combined))
head(combined)

}
\author{
Owen Jin
}
